#!/usr/bin/env node

'use strict';

const minimist = require('minimist');
const _ = require('lodash');
const checkDependencies = require('../lib/check-dependencies');

const argv = minimist(process.argv.slice(2));

// camelCase the options
for (const key in argv) {
    const value = argv[key];
    delete argv[key];
    argv[_.camelCase(key)] = value;
}

// Options of type array should always have array values
for (const option of ['scopeList', 'optionalScopeList']) {
    if (option in argv) {
        if (!Array.isArray(argv[option])) {
            argv[option] = [argv[option]];
        }
    }
}

// We'll handle verbosity by the CLI here.
const verbose = argv.verbose;
delete argv.verbose;

const Cli = {
    reporter(result) {
        if (verbose) {
            for (const msg of result.log) {
                console.log(msg);
            }
        }

        for (const msg of result.error) {
            console.error(msg);
        }

        if (result.error.length > 0) {
            process.exit(1); // eslint-disable-line no-process-exit
        }
    },
};

checkDependencies(argv, Cli.reporter);

module.exports = Cli;
