define('pgp_mail/toggle-encryption', [
    'mailvelope/main',
    'io.ox/core/capabilities',
    'gettext!oxguard',
    'settings!oxguard'
], function (api, capabilities, gt, settings) {

    'use strict';

    var ToggleEncryptionView = Backbone.View.extend({
        initialize: function () {
            this.listenTo(this.model, 'change:encrypt', function (model, val) {
                this.$('i.fa').toggleClass('encrypted', val);
                //gt('Click to enable encryption')
                //gt('Click to disable encryption')
            });
        },
        className: 'toggle-encryption',
        events: {
            'click i.fa': 'toggle',
            'change:encrypt': 'changed'
        },
        toggle: function () {
            if (this.encryption_forced) {
                require (['io.ox/core/notifications'], function (notify) {
                    notify.yell('error', gt('Reply must be encrypted'));
                });
            } else {
                this.model.set('encrypt', !this.model.get('encrypt'));
            }
        },
        forceEncryption: function () {
            this.encryption_forced = true;
            this.model.set('encrypt', true);
            this.render();
        },
        render: function () {
            var guard = false;
            if (window.oxguarddata !== undefined) {
                if (window.oxguarddata.settings !== undefined) {
                    guard = (window.oxguarddata.settings.oxguard === true);
                }
            }
            if (api.isMailvelopeSupported() || guard || this.encryption_forced)
                {
                if (!_.device('small'))
                this.$el.empty().append(
                    $('<i class="fa fa-2x">')
                    .toggleClass('encrypted', !!this.model.get('encrypt'))
                );
            }
            if (_.device('small')) {
                this.$el.addClass('mobile-toggle');
            }
            this.listenTo(this.model, 'change:encrypt', function () {
                this.changed();
            });
            return this;
        },
        noLinkMail: function (view) {
            this.view = view;
            checkAttLink (this.model, view);
            stopAttLink();
        },
        changed: function () {
            if (this.model && this.model.get('encrypt')) {
                showAttLink(this.view, false);
                checkAttLink(this.model);
                try {
                    var fromArray = this.model.get('from');
                    if (window.oxguarddata.primaryEmail !== undefined) {
                        if (window.oxguarddata.primaryEmail !== fromArray[0][1]) {
                            var warn = settings.get('warnEmailDifferent');
                            if (warn === undefined || warn === false) {
                                displayWarning();
                            }
                        }
                    }
                } catch (e) {
                    console.log(e);
                }
            } else {
                showAttLink(this.view, true);
            }
        }
    });

    // We need to disable the mail attachment link if encryption set
    function stopAttLink () {
        require (['io.ox/core/extPatterns/links'], function (links) {
            new links.Action('io.ox/mail/compose/attachment/shareAttachmentsEnable', {
                id: 'stop',
                index: 1,
                requires: function (e) {
                    try {
                        if (e.baton.view.model.get('encrypt')) {  // Do not offer shareAttachments if encrypted
                            console.log('stopping');
                            e.stopPropagation();
                            return false;
                        }
                    } catch (f) {
                        console.log(f);
                    }
                    return false;
                }
            });
        });
    }

    // Hide or show mail attachment link
    function showAttLink (view, show) {
        if (view) {
            if (show) {
                view.$el.find('.links.shareAttachments').show();
            } else {
                view.$el.find('.links.shareAttachments').hide();
            }

        }
    }

    // Check if Mail Attachment link is shown and encryption enabled
    function checkAttLink (model, view) {
        if (model.get('share_attachments')) {
            if (model.get('share_attachments').enable) {
                if (model.get('encrypt')) {
                    showAttLink(view,false);
                }
            }
        }
    }

    // Show a warning if Mail Attachment Link is shown and encryption clicked
    function checkAttLink (model) {
        if (model.get('share_attachments')) {
            if (model.get('share_attachments').enable) {
                require (['io.ox/core/tk/dialogs', 'settings!io.ox/mail'], function (dialogs, mail) {
                    var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true, enter: 'ok' });
                    dialog.header($('<h4>').text(gt('Not Supported')));
                    var text = $('<p>').text(gt('%s is not supported with secured email and will be disabled.', mail.get('compose/shareAttachments/name')));
                    dialog.getBody().append(text);
                    dialog
                    .addPrimaryButton('ok', gt('OK'), 'ok')
                    .show();
                });
            }
        }
    }

    // Warning that the from address is different from primary
    function displayWarning () {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true, enter: 'ok' });
            dialog.header($('<h4>').text(gt('Warning')));
            var text = $('<p>').text(gt('Sending an encrypted email from an account other than %s may cause problems with the recipient being able to reply.  Consider using your primary account.', window.oxguarddata.primaryEmail));
            var warn = $('<input type="checkbox" id="warnEmail">');
            var warntext = $('<span class="selectable" style="padding-left:10px;">').text(gt('Do not warn me again'));
            warntext.click(function () {
                warn.click();
            });
            warn.click(function (e) {
                settings.set('warnEmailDifferent', $(e.target).is(':checked'));
                settings.save();
            });
            dialog.getBody().append(text).append('<hr>').append(warn).append(warntext);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .show();
        });
    }

    return {
        View: ToggleEncryptionView
    };
});
