define('oxguard/tour/main', [
    'io.ox/core/tk/wizard',
    'io.ox/core/tk/hotspot',
    'oxguard/oxguard_core',
    'oxguard/util',
    'io.ox/core/capabilities',
    'io.ox/backbone/mini-views/help',
    'oxguard/core/createKeys',
    'settings!oxguard',
    'gettext!oxguard/tour'
], function (Tour, hotspot, core, util, capabilities, HelpView, keys, settings, gt) {
    'use strict';

    function writeMail() {
        ox.registry.call('mail-compose', 'compose')
        .done(function (e) {
            e.app.model.set('encrypt', true);
        });
    }

    function openFiles() {
        ox.launch('io.ox/files/main');
    }

    function openSettings() {
        ox.launch('io.ox/settings/main', { id: 'oxguard/pgp' }).then(function () {
            this.setSettingsPane({ id: 'oxguard/pgp' });
        });
    }
    function setEncryptDefault() {
        ox.launch('io.ox/settings/main', { id: 'oxguard/pgp' }).then(function () {
            this.setSettingsPane({ id: 'oxguard/pgp' });
            //FIXME: global settings?
            if (window.oxguarddata.settings && !window.oxguarddata.settings.pgpdefault) {
                $('#pgpdefault').click();
            }
        });
    }

    Tour.registry.add({
        id: 'default/oxguard',
        priority: 1
    }, function () {
        if (!util.isGuardConfigured()) {
            require(['settings!oxguard'], function (settings) {
                settings.set('cryptoProvider', 'guard').save();
            });
            Tour.registry.run('default/oxguard/createKeys');
            return;
        }

        var tour = new Tour(),
            composeApp;
        var driveText = '';
        var resetText = '';
        // Select text depending on if recovery is available
        if (window.oxguarddata.recoveryAvail) {
            resetText = gt.format(gt.pgettext('tour', 'You already set up your %s account. But you can always change your encryption password, or request a temporary password if you forget it.'), window.oxguarddata.productName);
        } else {
            resetText = gt.format(gt.pgettext('tour', 'You already set up your %s account.  You can change your encryption password here.'), window.oxguarddata.productName);
        }

        tour.step({ labelNext: gt('Next') })
            .title(gt.format(gt.pgettext('tour', 'The %s module'), window.oxguarddata.productName))
            .content(gt.pgettext('tour', 'Security and privacy matters to everyone. That\'s why you can now send and receive encrypted emails by simply clicking on the lock icon.'))
            .waitFor('.og-ready')
            .on('wait', function () {
                if (!composeApp) {
                    //compose not started, yet
                    ox.once('mail:compose:ready', function (mode, app) {
                        composeApp = app;
                        //HACK: can not detect that mail compose window is rendered
                        composeApp.view.$el.addClass('og-ready');
                        window.setTimeout(function () {
                            hotspot.add('.toggle-encryption', { 'top': 14, 'left': 14 });
                            composeApp.view.$el.find('.toggle-encryption .fa').click();
                        }, 500);
                    });
                    ox.registry.call('mail-compose', 'compose').done(function (e) {
                        composeApp = e.app;
                        composeApp.cid = 'compose.tour'; // Assign a CID for the app
                    });
                } else {
                    ox.ui.App.reuse(composeApp.cid);
                }
            })
            .on('next', function () {
                composeApp.view.$el.find('.toggle-encryption .fa').click();
            })
            .end();
        tour.once('stop', function () {
            if (composeApp && composeApp.model) {
                //prevent app from asking about changed content
                composeApp.model.dirty(false);
                composeApp.quit();
            }
        });

        tour
        .step()
            //#. %s product Name
            .title(gt.format(gt.pgettext('tour', '%s Security Settings'), window.oxguarddata.productName))
            .content(resetText)
            .on('wait', function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard' }).then(function () {
                    this.setSettingsPane({ id: 'oxguard' });
                });
            })
            .waitFor('.oxguard_settings.password')
            .spotlight('.oxguard_settings.password')
            .on('ready', function () {
                $('.oxguard_settings').css('padding', '10px');
            })
            .end()
        .step()
            .title((settings.get('advanced') ? gt.pgettext('tour', 'PGP Encryption Settings') : gt.pgettext('tour', 'Security Settings')))
            .content((settings.get('advanced') ?
                    gt.pgettext('tour', 'From here you can update your encryption settings. For example you can choose to send encrypted emails by default.') :
                    gt.pgettext('tour', 'From here, you can update your security settings.  For example, you can choose to send secure emails by default.')))
            .on('wait', function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard/pgp' }).then(function () {
                    this.setSettingsPane({ id: 'oxguard/pgp' });
                });
            })
            .waitFor('.oxguard_settings.defaults')
            .spotlight('.oxguard_settings.defaults')
            .hotspot('.oxguard_settings.defaults #pgpdefault', { 'top': 5, 'left': 5 })
            .on('ready', function () {
                $('.oxguard_settings').css('padding', '10px');
            })
            .end()
        .step()
            .title(gt.pgettext('tour', 'Signature'))
            .content(gt.pgettext('tour', 'In addition to encrypting your emails you can also sign them. This means that email recipients can be sure that the email really came from you. By ticking this checkbox your signature will be added to outgoing emails by default.'))
            .on('wait', function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard/pgp' }).then(function () {
                    this.setSettingsPane({ id: 'oxguard/pgp' });
                });
            })
            .waitFor('.oxguard_settings.defaults')
            .spotlight('.oxguard_settings.defaults')
            .hotspot('.oxguard_settings.defaults #pgpsign', { 'top': 5, 'left': 5 })
            .end();
        if (settings.get('advanced')) {
            tour.step()
            .title(gt.pgettext('tour', 'Alternative: PGP Inline'))
            .content(gt.format(gt.pgettext('tour', 'By default %s sends encrypted emails using PGP/Mime format. To communicate with some systems you may need to use PGP Inline.'), window.oxguarddata.productName))
            .on('wait', function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard/pgp' }).then(function () {
                    this.setSettingsPane({ id: 'oxguard/pgp' });
                });
            })
            .waitFor('.oxguard_settings.defaults')
            .spotlight('.oxguard_settings.defaults')
            .hotspot('.oxguard_settings.defaults #inlinedefault', { 'top': 5, 'left': 5 })
            .end()
            .step()
            .title(gt.pgettext('tour', 'Advanced Settings'))
            .content(gt.pgettext('tour', 'Advanced users can manage their key lists from the PGP Encryption Settings.'))
            .on('wait', function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard/pgp' }).then(function () {
                    this.setSettingsPane({ id: 'oxguard/pgp' });
                });
            })
            .waitFor('.oxguard_settings.keys')
            .spotlight('.oxguard_settings.keys')
            .end();
        } else {
            tour
            .step()
            .title(gt.pgettext('tour', 'Advanced User Settings'))
            .content($('<div>').append(
                    $('<p>').text(gt.pgettext('tour', 'Enabling Advanced PGP Features will enable key management and specifying sending formats.'))
             ))
             .waitFor('.pgpadvanced')
             .hotspot('.pgpadvanced', { 'top': 5, 'left': 5 })
             .spotlight('.selectable.pgpadvanced')
             .end();
        }
        tour
        .step()
            .title(gt.pgettext('tour', 'Enabling and disabling encryption'))
            .content($('<div>').append(
                $('<p>').text(gt.pgettext('tour', 'You are now able to send secure emails.')),
                $('<p>').text(gt.pgettext('tour', 'Sending without encryption is easy, too: Simply click on the lock icon again.'))
            ))
            .on('wait', function () {
                ox.ui.App.reuse(composeApp.cid);
                window.setTimeout(function () {
                    hotspot.add('.toggle-encryption', { 'top': 14, 'left': 14 });
                    composeApp.model.set('encrypt', false);
                }, 500);
            })
            .hotspot(['#statuslock'])
            .waitFor('.toggle-encryption .fa')
            .end();
        if (capabilities.has('guard-drive')) {
            tour.step()
            .title(gt.pgettext('tour', 'Encrypt files'))
            .content(gt.pgettext('tour', 'You can also protect your files. Just click on Encrypt and the selected file will be stored securely.'))
            .navigateTo('io.ox/files/main')
            .waitFor('.file-list-view')
            .hotspot('.classic-toolbar a[data-action=encrypt]', { 'top': 13, 'left': 10 })
            .on('wait', function () {
                window.setTimeout(function () {
                    $('.file-list-view > .list-item.selectable:not(.file-type-folder):not(.file-type-guard):first').click();
                    window.setTimeout(function () {
                        $('.classic-toolbar [data-action=more] ~ ul').css('display', 'block');
                        hotspot.add('.classic-toolbar a[data-action=encrypt]', { 'top': 13, 'left': 10 });
                    }, 500);
                }, 500);
            })
            .on('hide', function () {
                $('.classic-toolbar [data-action=more] ~ ul').css('display', '');
            })
            .end();
            driveText = $('<p>').append($('<a href="#">').click(openFiles).text(gt.pgettext('tour', 'Encrypt your sensitive files in Drive')));
        }
        tour
        .step()
            .title(gt.pgettext('tour', 'Restart Guided Tour'))
            .content(gt.pgettext('tour', '<em>Hint:</em> you can start guided tours, any time you need them, from the system menu.'))
            .hotspot('[data-action="guard-tour"]', { 'top': 13, 'left': 10 })
            .referTo('#topbar-settings-dropdown')
            .waitFor('#topbar-settings-dropdown')
            .on('wait', function () {
                $('#topbar-settings-dropdown').css('display', 'block');
            })
            .on('hide', function () {
                $('#topbar-settings-dropdown').css('display', '');
            })
            .end()
        .step()
            .title(gt.pgettext('tour', 'Guided Tour completed'))
            .content($('<div>').append(
                $('<p>').text(gt.pgettext('tour', 'You successfully learned how to protect your emails and files.')),
                $('<p>').text(gt.pgettext('tour', 'What you can do now:')),
                $('<p>').append($('<a href="#">').click(function () {
                    writeMail();
                    tour.close();
                }).text(gt.pgettext('tour', 'Write an encrypted email'))),
                driveText,
                $('<hr>'),
                $('<p>').append($('<a href="#">').click(setEncryptDefault).text(gt.pgettext('tour', 'Activate encryption for all new emails'))),
                $('<p>').append($('<a href="#">').click(openSettings).text(gt.pgettext('tour', 'Review your encryption settings'))),
                $('<p class="help">').append(new HelpView({
                    base: 'help-guard',
                    content: gt.pgettext('tour', 'Learn more')
                }).render().$el)
            ))
            .end()
        .start();
    });

    Tour.registry.add({
        id: 'default/oxguard/createKeys',
        priority: 1
    }, function () {
        var def = $.Deferred();

        var configured = util.isGuardConfigured();

        if (_.device('small') || _.device('smartphone')) {
            return keys.createKeys();
        }

        var tour = new Tour(),
            model = new keys.CreateKeysViewModel({
                initialSetup: true
            }),
            view = new keys.CreateKeysView({
                model: model
            });

        tour.once('stop', function () {
            if (model.get('sent') === false) {
                def.reject('cancel');
            } else {
                def.resolve('OK');
            }

            view.remove();
            model.off();
            view = model = null;
        });
        //Guard is not configured, yet.
        if (!configured) {
            tour.step({ labelNext: gt('Start Setup') })
            .title(gt.format(gt.pgettext('tour', 'Setup %s'), window.oxguarddata.productName))
            .content($('<div>').append(
                  //#. %s product name
                $('<p>').text(gt.format(gt.pgettext('tour', 'Welcome to %1$s. You will now be taken on a tour, showing you how to use %1$s.'),
                        window.oxguarddata.productName)))
                .append($('<p>').text(gt.format(gt.pgettext('tour', 'Firstly however, you’ll need to setup %1$s by choosing a password which will be used to encrypt or decrypt items such as email or files.'
                        ), window.oxguarddata.productName)))
                )
            .end()
        .step()
            //#. %s product name
            .title(gt('Choose %s Password', window.oxguarddata.productName))
            .content(view.render().$el)
            .beforeShow(function () {
                var self = this;
                this.toggleNext(false);
                model.on('change', function (model) {
                    self.toggleNext(model.isValid());
                });
                model.once('send:ok', function () {
                    //HACK: no way to pause the wizard until some event
                    $('body').addClass('og-ready');
                });
                window.setTimeout(function () {
                    if (_.device('desktop')) {
                        $('#newogpassword').focus();
                    } else {
                        $('[type="password"]').removeAttr('readonly');  // Remove the read only but do not focus.  User needs to click for keyboard
                    }
                }, 1000);
            })
            .on('next', function () {
                model.send();
            })
            .end();
        }

        // If we are already configured, can start with the offer for more tour
        if (configured) {
            $('body').addClass('og-ready');
        }

        tour
        .step({ labelDone: gt('Close') })
            //#. %s product Name
            .title(gt.format(gt.pgettext('tour', '%s set up completed'), window.oxguarddata.productName))
            .content($('<div>').append(
                $('<p>').text(gt.format(gt.pgettext('tour', 'Congratulations, you have successfully setup %s'), window.oxguarddata.productName)),
                $('<p>').text(gt.format(gt.pgettext('tour', 'Now you can learn more about how to use %s by following the links below:'), window.oxguarddata.productName)),
                $('<p>').append($('<a href="#">').click(function () {
                    $('.wizard-step .btn-primary').click();
                    Tour.registry.run('default/oxguard');
                    //#. %s product name
                }).text(gt('Guided tour for %s', window.oxguarddata.productName))),
                $('<p>').append(new HelpView({
                    base: 'help-guard',
                    content: gt.format(gt.pgettext('tour', 'Learn more about %s'), window.oxguarddata.productName)
                }).render().$el)
            ))
            .mandatory()
            .beforeShow(function () {
                //no going back, from here
                this.toggleBack(false);
            })
            .on('ready', function () {
                //HACK: no way to pause the wizard until some event
                $('body').removeClass('og-ready');
            })
            .waitFor('.og-ready')
            .end()
        .start();

        return def;
    });

    Tour.registry.add({
        id: 'default/oxguard/choice',
        priority: 1
    }, function () {
        return require(['settings!oxguard', 'oxguard/tour/choice', 'mailvelope/main'])
        .then(function (settings, Choice, api) {

            var def = $.Deferred();

            if (settings.get('cryptoProvider') !== undefined) {
                def.resolve(settings.get('cryptoProvider'));
                return def;
            } else if (api.isMailvelopeSupported() && (capabilities.has('forceMailvelope') || !capabilities.has('guard-mail'))) {
                settings.set('cryptoProvider', 'mailvelope').save();
                def.resolve('mailvelope');
                return (def);
            }

            var model = settings.createModel(Backbone.Model);
            new Tour().step()
                .title(gt('Choose your security solution'))
                .content(new Choice.View({
                    model: model
                }).render().$el)
                .beforeShow(function () {
                    var tour = this;
                    this.$el.addClass('choice_wizard');

                    this.$('[data-action="back"]').hide();
                    this.$('[data-action="next"]').hide();
                    this.$('[data-action="done"]').hide();

                    model.on('change:cryptoProvider', function (model, provider) {
                        settings.set('cryptoProvider', model.get('cryptoProvider'));
                        settings.save();
                        def.resolve(provider);
                        tour.trigger('done');
                    });
                })
                .end()
            .on('stop', function () {
                if (def.state() === 'pending' && settings.get('cryptoProvider') === undefined) def.reject('incomplete');
            })
            .start();

            return def;
        }).then(function (provider) {
            //FIXME: unify calls via Tour.registry API. if's are bad
            if (provider === 'guard') {
                return Tour.registry.get('default/oxguard/createKeys').get('run')();
            }
            if (provider === 'mailvelope') {
                return require(['mailvelope/tour']).then(function (runTour) {
                    return runTour();
                });
            }

            return provider;
        });
    });

    return Tour.registry;
});
