define('oxguard/tour/choice', [
    'gettext!oxguard',
    'less!oxguard/style'
], function (gt) {

    function title(title) {
        return $('<h3 class="text-center">').text(title);
    }

    function plus(content) {
        return $('<li class="row plus">').append(
            $('<span class="col-xs-2">').append($('<i class="fa fa-check-circle">')),
            $('<span class="col-xs-10">').text(content)
        );
    }

    function minus(content) {
        return $('<li class="row minus">').append(
            $('<span class="col-xs-2">').append($('<i class="fa fa-times-circle">')),
            $('<span class="col-xs-10">').text(content)
        );
    }

    function nextButton() {
        return $('<span class="btn btn-primary">').text(gt('Next'));
    }

    var GuardOptionView = Backbone.View.extend({
        className: 'guard',
        render: function () {
            this.$el.prop({
                'data-value': 'guard'
            }).empty().append(
                title(gt('Simple and Easy')),
                $('<div class="icon-large">').append(
                    $('<i>').addClass('fa fa-lightbulb-o')
                ),
                $('<ul class="list-unstyled arguments">').append(
                    plus(gt.pgettext('Choice', 'One click encryption for Emails and files')),
                    plus(gt.pgettext('Choice', 'Works in all browsers with all your contacts')),
                    plus(gt.pgettext('Choice', 'Easy to use, every day')),
                    plus(gt.pgettext('Choice', 'Security details managed by us'))
                ),
                $('<p>').text(gt.pgettext('Choice', 'If you do not have deep knowledge of encryption, but you would like to easily secure your communication with your friends or business contacts, this option fits perfectly for you. Safe Email, made simple!')),
                nextButton()
            );
            return this;
        }
    });

    var MailvelopeOptionView = Backbone.View.extend({
        className: 'mailvelope',
        render: function () {
            this.$el.prop({
                'data-value': 'mailvelope'
            }).empty().append(
                title(gt.pgettext('Choice', 'Encryption Expert')),
                $('<div class="icon-large">').append(
                    $('<i>').addClass('fa fa-flask')
                ),
                $('<ul class="list-unstyled arguments">').append(
                    plus(gt.pgettext('Choice', 'Expert encryption options available')),
                    minus(gt.pgettext('Choice', 'Works only in Firefox and Chrome')),
                    minus(gt.pgettext('Choice', 'Browser plugin required')),
                    minus(gt.pgettext('Choice', 'Security details managed by yourself'))
                ),
                $('<p>').text(gt.pgettext('Choice', 'If you are an encryption expert, and would like to manage all encryption details by yourself, this option fits best for you. You need to install a third-party browser plugin to work with expert encryption.')),
                nextButton()
            );
            return this;
        }
    });

    var ChoiceView = Backbone.View.extend({
        className: 'security-provider-choice',
        events: {
            'click a.option': 'makeChoice'
        },
        makeChoice: function (ev) {
            var provider = $(ev.currentTarget).children(':first').prop('data-value');
            this.model.set('cryptoProvider', provider);
        },
        render: function () {
            this.$el.empty().append($('<div class="row">').append(
                $('<span class="col-md-6 col-sm-12">').append($('<a class="option" tabindex="1" href="#">').append(new GuardOptionView().render().$el)),
                $('<span class="col-md-6 col-sm-12">').append($('<a class="option" tabindex="1" href="#">').append(new MailvelopeOptionView().render().$el))
            ));
            return this;
        }
    });

    return {
        View: ChoiceView
    };
});
