define('oxguard/settings/pane', [
    'io.ox/core/extensions',
    'io.ox/core/tk/dialogs',
    'oxguard/crypto/encr',
    'oxguard/core/og_http',
    'oxguard/util',
    'oxguard/core/emailverify',
    'io.ox/backbone/mini-views/help',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'settings!oxguard'
], function (ext, dialogs, encr, og_http, util, verify, HelpView, core, gt, settings) {
    'use strict';

    function setupGuard (where) {
        var passheader =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Get Started') + '</legend></br>');
        var instructions = $('<div>');
        //#. product name
        instructions.append('<p>' + gt('In order to start with %s Security, you must set up a password for your secured files.', window.oxguarddata.productName) + '</p>');
        var startButton = $('<button type="button" class="btn btn-primary">' + gt('Start') + '</button>');
        startButton.click (function () {
            require(['oxguard/core/createKeys'], function (keys) {
                core.metrics('settings', 'create-keys');
                keys.createKeysWizard()
                .done(function (result) {
                    if (result === 'OK') draw(where);
                    //$('.oxguard_settings').replaceWith(addSettings());
                });
            });
        });
        var holder = $('<div>').css('max-width', '800px');
        //#. %s product name
        holder.append('<h1>' + gt('%s Security Settings', window.oxguarddata.productName) + '</h1><br/>');
        where.append(holder.append(passheader.append(instructions).append(startButton)));
    }

    // Add click action to element if the user hits enter key
    function checkEnter (element, clickEl) {
        element.on('keyup', function (e) {
            if (e.keyCode === 13) {
                clickEl.click();
            }
        });
    }

    function createPasswordChange() {
        var passheader =
        $('<div class="oxguard_settings password"/>')
        .append('<legend class="sectiontitle">' + gt('Password') + '</legend></br>')
        //#. %s product name
        .append('<span> ' + gt('Change %s Security Password.', window.oxguarddata.productName) + '</span><br/>');
        var newpass1 = $('<input type="password" id="newpass1" name="newpass1" autocomplete="off"/>');
        var td = $('<td>').append(newpass1);
        var newpass2 = $('<input type="password" id="newpass2" name="newpass2" autocomplete="off"/>');
        var td2 = $('<td>').append(newpass2);
        var hint = $('<td style="width:150px;">');
        var curPrompt = $('<label for="oldpass">').append(gt('Enter current %s security password', window.oxguarddata.productName));
        var prompt1 = $('<label for="newpass1">').append(gt('Enter new %s security password', window.oxguarddata.productName));
        var prompt2 = $('<label for="newpass2">').append(gt('Verify new %s security password', window.oxguarddata.productName));
        var oldpass = $('<input type="password" id="oldpass" name="oldpass" autocomplete="off" />');
        var passwordTable;
        if (_.device('small')) {
            passwordTable = $('<div style="padding:10px;">');
            if (!window.oxguarddata['new']) {
                passwordTable        //#. %s product name
                .append(curPrompt).append('<br>').append(oldpass).append('<br>');
            }
            passwordTable
            .append(prompt1).append('<br>').append(newpass1).append('<br>')
            .append(prompt2).append('<br>').append(newpass2);
        } else {
            passwordTable = $('<table/>');
            if (!window.oxguarddata['new']) {
                passwordTable        //#. %s product name
                .append($('<tr>').append(($('<td>').append(curPrompt))).append($('<td>').append(oldpass)));
            }
            passwordTable
            .append($('<tr>').append(($('<td>').append(prompt1))).append(td).append(hint))
            .append($('<tr>').append(($('<td>').append(prompt2))).append(td2).append($('<td>')));
        }

        require (['oxguard/core/passwords'], function (pass) {
            pass.passwordCheck(newpass1, hint);
            pass.passwordCompare(newpass2, newpass1, hint);
        });
        //#. %s product name
        var passButton = $('<button type="button" class="btn btn-primary" style="margin-top:10px;">' + gt('Change %s security password', window.oxguarddata.productName) + '</button>');
        passButton.click(passChanged);
        checkEnter (newpass2, passButton);
        return (passheader.append(passwordTable).append(passButton));
    }

    function createPasswordReset() {
        if (!window.oxguarddata.recovery || window.oxguarddata['new']) {  // If no recovery avail, then don't display reset button
            return ('');
        }
        var passheader =
            $('<div class="oxguard_settings password password-reset"/>')
            //#. %s product name
            .append('<legend class="sectiontitle">' + gt('Reset %s security password', window.oxguarddata.productName) + '</legend></br>')
            .append('<span> ' + gt('Send a temporary %s security password to my secondary Email address.', window.oxguarddata.productName) + '</span><br/>');
        //#. %s product name
        var passButton = $('<button type="button" class="btn btn-primary" style="margin-top:10px;">' + gt('Reset %s security password', window.oxguarddata.productName) + '</button>');
        passButton.click(doReset);
        return (passheader.append(passButton));
    }

    function createDeleteRecovery() {
        if (window.oxguarddata.settings.noDeleteRecovery || !window.oxguarddata.recovery || !settings.get('advanced')) {
            return ('');
        }
        var header = $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Delete Password Recovery') + '</legend></br>')
            .append('<b>' + gt('Advanced Users Only!') + '</b><br>')
            .append('<span> ' + gt('Delete the password recovery.  The recovery is used to reset your password.  If you delete the recovery, you will not be able to reset your password if you forget it.  Changing your password will restore the recovery.') + '</span><br/>');
        var deleteRecoveryButton = $('<button type="button" class="btn btn-primary">' + gt('Delete Password Recovery') + '</button>');
        deleteRecoveryButton.click(doDeleteRecovery);
        return (header.append(deleteRecoveryButton));
    }

    function doDeleteRecovery() {
        require (['io.ox/core/notifications'], function (notify) {
            core.getPassword(gt('Please verify your password before deleting the recovery.'))
            .done (function (e) {
                var data = {
                    userid: ox.user_id,
                    cid: ox.context_id,
                    password: e.password
                };
                core.metrics('settings', 'delete-recovery');
                og_http.post(ox.apiRoot + '/oxguard/login?action=deleterecovery', '', data)
                .done (function () {
                    notify.yell('success', gt('Recovery deleted'));
                    window.oxguarddata.recovery = false;
                    redraw();
                })
                .fail (function (e) {
                    if (e.responseText.trim() === 'Bad password') {
                        notify.yell('error', gt('Bad Password'));
                    } else {
                        notify.yell('error', e.responseText);
                    }
                });
            });
        });
    }

    function createSecondaryChange() {
        if (window.oxguarddata.settings.noRecovery === true || window.oxguarddata.recovery === false) return;  // Don't display secondary email if no recovery is set
        updateEmail();
        var current = $('<span>').append(gt('Current Email address:'));
        var currentEmail = $('<span id="currentsecondary" style="padding-left:20px;">');
        var emailheader =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Secondary Email') + '</legend></br>')
            .append('<span> ' + gt('Change Email address used for password reset.') + '</span><br/><br/>');
        if (_.device('small')) {
            emailheader.append(current).append('<br>').append(currentEmail);
        } else {
            emailheader.append(current).append(currentEmail);
        }
        var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
        var emailPass = $('<input id="newemail" name="newemail"/>');
        var verifyPass = $('<input id="newemailverify" name="newemailverify">');
        var currentPrompt = $('<label for="ogpass">').append(gt('Enter current %s security password', window.oxguarddata.productName));
        var currentInput = $('<input type="password" id="ogpass" name="ogpass" autocomplete="off"/>');
        var newPrompt = $('<label for="newemail">').append(gt('Enter new secondary Email address'));
        var verifyPrompt = $('<label for="newemailverify">').append(gt('Verify Email address'));
        var hint = $('<td>');
        var emailTable;
        if (_.device('small')) {
            emailTable = $('<div style="margin-top:15px;margin-left:10px;">')
            .append(currentPrompt).append('<br>').append(currentInput).append('<br>')
            .append(newPrompt).append('<br>').append(emailPass).append('<br>')
            .append(verifyPrompt).append('<br>').append(verifyPass);
        } else {
            emailTable = $('<table/>')
            .append(noSaveWorkAround)
            //#. %s product name
            .append($('<tr>').append($('<td>').append(currentPrompt)).append($('<td>').append(currentInput)))
            .append($('<tr>').append($('<td>').append(newPrompt)).append($('<td>').append(emailPass)).append(hint))
            .append($('<tr>').append($('<td>').append(verifyPrompt)).append($('<td>').append(verifyPass)));
        }
        var errorDiv = $('<div id="newemailerror" class="alert alert-info" style="display:none"/>');
        var emailButton = $('<button type="button" class="btn btn-primary">' + gt('Change Email address') + '</button>');
        verify.setValidate(emailPass, hint);
        verify.autoCompare(emailPass, verifyPass, hint);
        checkEnter(verifyPass, emailButton);
        emailButton.click(emailChanged);
        return (emailheader.append(emailTable).append(errorDiv).append(emailButton));
    }

    function updateEmail () {
        og_http.get(ox.apiRoot + '/oxguard/login?action=secondary', '&userid=' + ox.user_id + '&cid=' + ox.context_id)
        .done(function (d) {
            d = d.trim();
            if (d.length < 2) {
                //#. No recovery email was given, so we will use the primary email address when resetting
                $('#currentsecondary').html(gt('None - Primary Email will be used'));
            } else {
                $('#currentsecondary').html(d);
            }
        });
    }

    function emailChanged () {
        var email = $('input[name="newemail"]').val();
        var verifyEmail = $('input[name="newemailverify"]').val();
        if (email !== verifyEmail) {
            showError(gt('Emails not equal'));
            return;
        }
        if (!verify.validate(email)) {
            showError(gt('Invalid email address'));
        } else {
            var data = {
                userid: ox.user_id,
                cid: ox.context_id,
                email: email,
                password: $('input[name="ogpass"]').val()
            };
            core.metrics('settings', 'change-secondary-email');
            og_http.post(ox.apiRoot + '/oxguard/login?action=changesecondary', '', data)
            .done(function () {
                showOK(gt('Successfully changed email address'));
                updateEmail();
                $('input[name="ogpass"]').val('');
                $('input[name="newemail"]').val('');
                $('input[name="newemailverify"]').val('');
            })
            .fail(function (d) {
                if (d.responseText.trim() === 'Bad password') {
                    showError(gt('Bad Password'));
                    if (!_.device('ios')) {
                        $('input[name="ogpass"]').focus();
                    }
                }
            });
        }
    }

    function showOK (msg) {
        require(['io.ox/core/notifications'], function (notify) {
            notify.yell('success', msg);
        });
    }

    function showError (msg) {
        require(['io.ox/core/notifications'], function (notify) {
            notify.yell('error', msg);
        });
    }

    function doReset() {
        require(['io.ox/core/api/account'], function (api) {
            api.getPrimaryAddress().done(function (data) {// Get primary address as backup
                var primaryEmail = data[1];
                var waitdiv = $('<div class="og_wait" id="keygen"></div');
                waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
                $('.window-container-center').append(waitdiv);
                waitdiv.show();
                var param = '&userid=' + ox.user_id + '&cid=' + ox.context_id +
                '&default=' + encodeURIComponent(primaryEmail) + '&lang=' + ox.language;
                core.metrics('settings', 'reset-password');
                og_http.get(ox.apiRoot + '/oxguard/login?action=reset', param)
                .done(function (data) {
                    $('.og_wait').remove();
                    core.removeAuth();
                    require(['io.ox/core/notifications'], function (notify) {
                        if (data.indexOf('primary') >= 0) {
                            notify.yell('success', gt('A new password has been sent to your email address.'));
                            window.oxguarddata.passcode = 'Password Needed';
                            return;
                        }
                        if (data.indexOf('ok') >= 0) {
                            notify.yell('success', gt('A new password has been sent to your secondary email address.'));
                            window.oxguarddata.passcode = 'Password Needed';
                            return;
                        }
                        if (data.trim() === 'NoRecovery') {
                            notify.yell('error', gt('No password recovery is available.'));
                            return;
                        }
                        if (data.indexOf('FailNotify') >= 0) {
                            notify.yell('error', gt('Password reset, but unable to send to your email address.'));
                            return;
                        }
                        if (data.indexOf('NoSecondary') >= 0) {
                            notify.yell('error', gt('Unable to find email address to send password reset.'));
                            return;
                        }
                        notify.yell('error', gt('Unable to reset your password'));
                    });
                })
                .fail(function () {
                    $('.og_wait').remove();
                    require(['io.ox/core/notifications'], function (notify) {
                        notify.yell('error', gt('Unable to reset your password'));
                    });
                });
            });
        });
    }

    function passChanged() {

        var newpass = $('input[name="newpass1"]');
        var newpass2 = $('input[name="newpass2"]');
        var min = window.oxguarddata.settings.min_password_length;
        if (min !== undefined) {
            if (newpass.val().length < min) {
                showError(gt('New password must be at least %s characters long', min));
                if (!_.device('ios')) {
                    newpass.focus();
                }
                return;
            }
        }
        if (newpass.val() !== newpass2.val()) {
            newpass2.css('background-color', 'salmon');
            return;
        } else {
            newpass2.css('background-color', 'white');
            var userdata = {
                    newpass: newpass.val(),
                    oldpass: ($('input[name="oldpass"]').val() === undefined ? '' : $('input[name="oldpass"]').val()),
                    user_id: ox.user_id,
                    sessionID: ox.session,
                    cid: ox.context_id,
                    user: ox.user
                };
            var waitdiv = $('<div class="og_wait" id="keygen"></div');
            waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
            $('.window-container-center').append(waitdiv);
            waitdiv.show();
            core.metrics('settings', 'change-password');
            og_http.post(ox.apiRoot + '/oxguard/login?action=changepass', '', userdata)
            .done(function (data) {
                $('.og_wait').remove();
                if (typeof data === 'string') data = $.parseJSON(data);
                if (data.auth === undefined) {
                    require(['oxguard/core/errorHandler'], function (err) {
                        err.showError(data);
                    });
                    return;
                }
                if (data.auth === 'Bad password') {
                    showError(gt('Bad password'));
                }
                if (data.auth === 'Lockout') {
                    showError(gt('Temporary Lockout'));
                }
                if (data.auth === 'Bad new password') {
                    showError(gt('New password must be at least %s characters long', data.minlength));
                }
                if (data.auth.length > 20) {
                    $('input[name="newpass1"]').val('');
                    $('input[name="newpass2"]').val('');
                    $('input[name="oldpass"]').val('');
                    window.oxguarddata.passcode = null;
                    window.oxguarddata.recovery = data.recovery;
                    window.oxguarddata['new'] = false;
                    redraw();
                    showOK(gt('Password changed successfully'));
                    core.removeAuth(); // We want to remove rembered auth codes, as the password has changed
                }
            })
            .fail(function (e) {
                $('.og_wait').remove();
                var error = gt('Failed to change password');
                if (e.responseText.trim() === 'Bad Password') {
                    error = gt('Bad password');
                }
                showError(error);
            });
            return;
        }
    }

    ext.point('oxguard/settings/detail').extend({
        index: 100,
        id: 'oxguardsettings',
        draw: function () {
            var node = this;
            if (util.isGuardLoaded()) {
                draw (node);
            } else {
                util.addOnLoaded(function () {
                    draw(node);
                });
            }
        },
        save: function () {
        }
    });

    function draw (node) {
        $(node).empty();
        util.hasSetupDone()
        .done(function () {
            if (settings.get('cryptoProvider') === 'mailvelope') {
                require(['mailvelope/settings/pane'], function (mSettings) {
                    mSettings.drawMailvelopeSettings(node);
                });
                return;
            }
            node.append(addSettings());
        })
        .fail (function () {
            require(['io.ox/core/capabilities'], function (capabilities) {
                if (capabilities.has('guard-mail') || capabilities.has('guard-drive')) {
                    node.append(setupGuard(node));
                }
            });
            return;
        });

    }

    // Redraw
    function redraw () {
        $('#guard_settings').replaceWith(addSettings());
    }

    function addSettings () {
        var holder = $('<div id="guard_settings">').css('max-width', '800px');
        //#. %s product name
        var message = $('<span>').append(gt('%s Security Settings', window.oxguarddata.productName));
        message.append(new HelpView({
            base: 'help-guard',
            iconClass: 'guardhelp',
            href: 'ox.guard.user.sect.usage.settings.security.html',
            tabindex: '-1'
        }).render().$el);
        var header = $('<h1>').append(message);
        holder.append(header);
        return (holder.append(createPasswordChange()).append(createPasswordReset()).append(createSecondaryChange()).append(createDeleteRecovery()));
    }

    return {
        updateEmail: updateEmail
    };
});
