define('oxguard/pgp/settings/pane', [
    'io.ox/core/extensions',
    'io.ox/core/tk/dialogs',
    'oxguard/pgp/publickeys',
    'oxguard/core/og_http',
    'oxguard/util',
    'oxguard/core/passwords',
    'oxguard/oxguard_core',
    'settings!oxguard',
    'io.ox/backbone/mini-views/help',
    'gettext!oxguard'
], function (ext, dialogs, pubkeys, http, util, passwords, core, settings, HelpView, gt) {
    'use strict';

    var userKeyData = null;
    var thisNode = null;

    function downloadPublic() {
        var pgpHeader = $('<div style="padding-bottom:20px;">');
        var downloadbutton = $('<button type="button" class="btn btn-primary" style="margin-right:20px;">' + gt('Download PGP Public Key') + '</button>');
        downloadbutton.on('click', function () {
            var params = '&id=' + ox.user_id + '&cid=' + ox.context_id + '&session=' + ox.session;
            window.open(ox.apiRoot + '/oxguard/pgpmail/public.asc?action=getkeybyid' + params, '_blank');
        });

        var sendButton = $('<button type="button" class="btn btn-primary">' + gt('Email your PGP Public Key') + '</button>')
         .on('click', sendPublic);
        pgpHeader.append(downloadbutton).append(sendButton);
        return (pgpHeader);
    }

    ///// Local Key Management

    function keys() {
        if (!settings.get('advanced')) return;
        var header = $('<legend class="sectiontitle" style="margin-bottom:5px;">').append(gt('Your Keys'));
        header.append(new HelpView({
            base: 'help-guard',
            iconClass: 'guardhelp',
            href: 'ox.guard.user.sect.usage.settings.keys.html',
            tabindex: '-1'
        }).render().$el);
        var pgpHeader = $('<div class="oxguard_settings keys"/>')
        .append(header)
        .append(downloadPublic())
        .append(userKeys());
        return (pgpHeader);
    }

    // List of users private keys
    function userKeys() {
        var pubdiv = $('<div class="publicKeyDiv"/>');
        var tableHeader = $('<b>' + gt('Your Key List') + '</b>');
        var refresh = $('<a href="#" style="margin-left:10px;" aria-label="' + gt('Refresh') + '"><icon class="fa fa-refresh fa-spin" id="refreshuserkeys"></a>')
            .click(function (e) {
                $(this).addClass('fa-spin');
                updateUserKeyTable().done(function () {
                    refresh.removeClass('fa-spin');
                });
                e.preventDefault();
            });
        var addKey = $('<a href="#" style="margin-left:10px;" aria-label="' +
            gt('Create %s Security Keys', window.oxguarddata.productName) + '"><icon class="fa fa-plus" id="adduserkeys"></a>')
        .click(function (e) {
            uploadLocalKeysDialog();
            e.preventDefault();
        });
        tableHeader.append(refresh).append(addKey);
        var tablediv = $('<div class="keytable">');
        var table = $('<table id="userkeytable">');
        pubdiv.append(tableHeader.append(tablediv.append(table)));
        updateUserKeys();
        return (pubdiv);
    }

    function updateUserKeys() {
        $('#refreshuserkeys').addClass('fa-spin');
        updateUserKeyTable().done(function () {
            $('#refreshuserkeys').removeClass('fa-spin');
        });
    }

    function updateUserKeyTable() {
        var deferred = $.Deferred();
        var params = '&userid=' + ox.user_id + '&cid=' + ox.context_id;
        // Send the request to the oxguard server for the encrypted content key to decrypt
        http.get(ox.apiRoot + '/oxguard/pgp?action=getuserkeys', params)
        .done(function (grpdata) {
            grpdata = JSON.parse(grpdata);
            userKeyData = grpdata;
            var newtable = $('<table id="userkeytable">');
            var headers = $('<th scope="col">' + gt('Key ID') + '</th><th scope="col">'  + gt('Private Key') + '</th><th scope="col">' + gt('Current') + '</th><th scope="col">' + gt('Details') + '</th><th scope="col">' + gt('Delete') + '</th><th scope="col">' + gt('Download') + '</th><th scope="col">' + gt('Edit') + '</th>' );
            if (grpdata.length !== 0) {
                newtable.append(headers);

                for (var grp = 0; grp < grpdata.length; grp++) {
                    var data = grpdata[grp];
                    for (var i = 0; i < data.length; i++) {
                        var tr = (data[i].Revoked || data[i].Expired) ? $('<tr style="color:red;">') : $('<tr>');
                        if (data[i].Revoked) $(tr).css('text-decoration', 'line-through');
                        var td1 = $('<th scopre="row" style="text-align:left;">');
                        if (data[i].Master === false) {
                            td1.append('<i class="fa fa-level-up fa-rotate-90" style="padding-right:7px; vertical-align:bottom;"></i>');
                        }
                        td1.append($('<span style="padding-left:5px;">' + data[i].Key + '</span>'));
                        tr.append(td1);
                        var td2 = $('<td>');
                        td2.append(data[i].hasPrivate ? '<icon class="fa fa-check" title="' + gt('Private Key') + '"/>' : '');
                        tr.append(td2);
                        var td3 = $('<td>');
                        if (data[i].current) {
                            td3.append('<icon class="fa fa-check" title="' + gt('Current') + '"/>');
                        } else {
                            var makecurrent = $('<input type="checkbox" id="makeCurrent" aria-label="' + gt('Current') + '" class="makecurrent" value="' + data[i].GuardKey + '"/>');
                            td3.append(makecurrent);
                        }

                        tr.append(td3);
                        var td4 = $('<td>');
                        var search = $('<a class="userpgpdetail" aria-label="' + gt('Details') + '" ids="' + grp + ',' + i + '" href="#"><icon class="fa fa-search"/></a>');
                        td4.append(search);
                        var td5 = $('<td>');
                        var del = $('<a href="#" aria-label="' + gt('Delete') + '" value="' + grp + ',' + i + '" class="delPriv"><icon class="fa fa-trash"/></a>');
                        td5.append(del);
                        var td6 = $('<td>');
                        var down = $('<a class="keydownload" aria-label="' + gt('Download') + '" href="#" value="' + grp + ',' + i + '"><icon class="fa fa-download"/></a>');
                        td6.append(down);
                        var td7 = $('<td>');
                        var edit = $('<a class="keyedit" aria-label="' + gt('Edit') + '" href="#" value="' + data[i].KeyLong + '"><icon class="fa fa-pencil"/></a>');
                        td7.append(edit);
                        tr.append(td4).append(td5).append(td6).append(td7);
                        newtable.append(tr);
                    }
                    if ((grp + 1) < grpdata.length) {
                        var spacer = $('<tr>').append($('<td style="padding:1px;">').append('<hr style="border-top:1px solid #A59292; margin:5px;">'));
                        newtable.append(spacer);
                    }
                }

                $('#userkeytable').replaceWith(newtable);
                $('.userpgpdetail').on('click', function (e) {
                    var id = $(this).attr('ids');
                    showLocalDetail(id);
                    e.preventDefault();
                });
                $('.keydownload').on('click', function (e) {
                    var id = $(this).attr('value');
                    download(id);
                    e.preventDefault();
                });
                $('.makecurrent').on('click', function (e) {
                    var id = $(this).attr('value');
                    makeCurrent(id);
                    e.preventDefault();
                });
                $('.delPriv').on('click', function (e) {
                    var id = $(this).attr('value');
                    deletePrivateStage1(id);
                    e.preventDefault();
                });
                $('.keyedit').on('click', function (e) {
                    var id = $(this).attr('value');
                    editUID(id);
                    e.preventDefault();
                });
            } else {
                $('#userkeytable').replaceWith('<table id="userkeytable"><tr><td>' + gt('No Keys Found') + '</td></tr></table>');
            }
            deferred.resolve('OK');
            hideWait();
        })
        .fail (function () {
            hideWait();
        });
        return (deferred);
    }

    // Dialog for uploading private or public key to server
    function uploadLocalKeysDialog () {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Adding Keys')));

            var uploadheader = $('<p>' + gt('If you already have a private key, you can upload it here.') + '</p>');
            var uploadbutton = $('<button type="button" class="btn btn-primary">' + gt('Upload Private Key') + '</button>');
            uploadbutton.on('click', function () {
                fileinput.unbind('change');
                fileinput.on('change', function () {
                    var files = this.files;
                    if (files.length > 0) {
                        require(['oxguard/pgp/uploadkeys'], function (uploader) {
                            uploader.uploadPrivate(files)
                            .done(function () {
                                updateUserKeyTable();
                                fileinput.val('');
                            })
                            .fail(function () {
                                fileinput.val('');
                            });
                        });
                    }
                });
                fileinput.click();
                dialog.close();
            });
            var fileinput;
            var findfile = $('#guardFiles').find('[name="localPrivateKey"]');
            if (findfile.length > 0) {
                fileinput = findfile;
            } else {
                fileinput = $('<input type="file" name="localPrivateKey" style="display:none;">');
                $('#guardFiles').append(fileinput);
            }
            var createNewHeader = $('<br><p>' + gt('Finally, you can have a new PGP Key Pair created for your account.') + '</p>');
            var createButton = $('<button type="button" class="btn btn-primary">' + gt('Create New Keys') + '</button>')
            .click(function () {
                createNew();
                dialog.close();
            });
            dialog.getBody().append(uploadheader).append(uploadbutton).append(uploadLocalPublic(dialog)).append(createNewHeader).append(createButton);
            dialog
            .addPrimaryButton('cancel', gt('Cancel'), 'cancel')
            .show();
        });
    }

    function editUID (id, error) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Adding UserID')));
            var instr = $('<p>' + gt('Add a name and email address to this public key.') + '</p>');
            var table = $('<table class="oxguard_settings">');
            var tr1 = $('<tr>');
            var td1 = $('<td>' + gt('Name') + '</td>');
            var name = $('<input type="text" name="uidName"/>');
            tr1.append(td1).append($('<td>').append(name));
            var tr2 = $('<tr>');
            var td2 = $('<td>' + gt('Email') + '</td>');
            var email = $('<input type="text" name="uidEmail"/>');
            tr2.append(td2).append($('<td>').append(email));
            table.append(tr1).append(tr2);
            var instr2 = $('<span style="margin-top:5px; display:block;">' + gt('Please enter your key password') + '</span></br>');
            var pass = passwords.createPasswordInput('uidPassword');
            var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
            var errortext = $('<br><span style="color:rgb(237, 81, 81); padding:15px; display:none; float:right;" name="uidError"></span>');
            dialog.getBody().append(instr).append(table).append(instr2).append(noSaveWorkAround).append(pass).append(errortext);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('ok', function () {
                var email = $('[name="uidEmail"]').val();
                var name = $('[name="uidName"]').val();
                var password = $('[name="uidPassword"]').val();
                require(['io.ox/core/notifications'], function (notify) {
                    if (!core.validateEmail(email)) {
                        editUID(id, gt('Invalid Email Address'));
                        return;
                    }
                    if (name.length < 2) {
                        editUID(id, gt('Invalid Name'));
                        return;
                    }
                    if (password.length < 2) {
                        editUID(id, gt('Enter password'));
                    }
                    var data = {
                        password: password,
                        email: email,
                        name: name
                    };
                    core.metrics('settings', 'edit-pgp-uid');
                    var params = '&userid=' + ox.user_id + '&cid=' + ox.context_id + '&keyid=' + id;
                    http.post(ox.apiRoot + '/oxguard/pgp?action=adduserid', params, data)
                    .done (function () {
                        notify.yell('success', gt('User ID added'));
                        updateUserKeyTable();
                        return;
                    })
                    .fail(function (e) {
                        if (e.responseText.trim() === 'Bad password') {
                            editUID(id, gt('Bad password'));
                            return;
                        }
                        notify.yell('error', gt('Failed to add UserID') + e.responseText);
                    });
                });
            })
            .show(function () {
                if (error !== undefined) {
                    $('[name="uidError"]').text(error).show();
                }
            });
        });
    }

    function deletePrivateStage1(id) {
        var data = getCacheData (id);
        if (!data.hasPrivate) {
            deleteLocalPublic(data.GuardKey);
            return;
        }
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
            if (window.oxguarddata.settings.noDeletePrivate) {
                dialog.header($('<h4>').text(gt('Revoke Private Key')));
                var body = $('<p>' + gt('Revoke the key: This advises others that you no longer want this key used.  You can continue to decode any encrypted data using the key.') + '</p>');
                dialog.getBody().append(body);
            } else {
                dialog.header($('<h4>').text(gt('Delete Private Key')));
                var body = $('<p>' + gt('There are two options if you no longer want to use this key') + '</p>');
                var body2 = $('<p>' + gt('Revoke the key: This advises others that you no longer want this key used.  You can continue to decode any encrypted data using the key. (Recommended)') + '</p>');
                var body3 = $('<p>' +
                    gt('Deleting the key: Deleting the private key will render all encrypted items unreadable.  You will not be able to decode emails or files that were enrypted with this key.  This cannot be undone.') +
                    '</p>');
                dialog.getBody().append(body).append(body2).append(body3);
            }
            dialog
            .addPrimaryButton('cancel', gt('Cancel'), 'cancel')
            .addButton('revoke', gt('Revoke'), 'revoke');
            if (!window.oxguarddata.settings.noDeletePrivate) {
                dialog.addButton('delete', gt('Delete'), 'delete');
            }
            dialog.on('delete', function () {
                deletePrivateStage2(data.GuardKey);
            })
            .on('revoke', function () {
                retractPrivate(data.GuardKey);
            })
            .show();
        });
    }

    function deletePrivateStage2(keyid) {
        require (['io.ox/core/tk/dialogs', 'oxguard/oxguard_core', 'io.ox/core/notifications'], function (dialogs, core, notify) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'delete' });
            dialog.header($('<h4>').text(gt('Delete Private Key')));
            var body = $('<p>' + gt('You will no longer be able to decode any items that were encrypted with this key!') + '</p>');
            var body2 = $('<p>' + gt('Enter your password below to confirm and verify') + '</p>');
            var password = passwords.createPasswordInput('deletepass');
            var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
            dialog.getBody().append(body).append(body2).append(noSaveWorkAround).append(password);
            dialog.addPrimaryButton('delete', gt('Delete'), 'delete')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('delete', function () {
                var pass = $('#deletepass').val();
                if (pass.length > 1) {
                    core.auth(ox.user_id, pass, null, keyid)
                    .done (function (data) {
                        if (data.auth === 'Bad Password') {
                            notify.yell('error', gt('Bad Password'));
                            return;
                        }
                        if (data.auth.length > 20) {
                            var json = {
                                keyid: keyid,
                                auth: data.auth,
                                userid: ox.user_id,
                                cid: ox.context_id
                            };
                            var params = '';
                            core.metrics('settings', 'delete-private-key');
                            http.post(ox.apiRoot + '/oxguard/pgp?action=deleteprivkey', params, json)
                            .done (function () {
                                updateUserKeys();
                                if (userKeyData.length < 2) {
                                    notify.yell('success', gt('Key Deleted'));
                                    //uploadLocalKeysDialog();
                                    createNew();
                                }
                            })
                            .fail (function (e) {
                                notify.yell('error', gt('Failed to delete key'));
                                console.log(e);
                            });
                            // do delete
                            return;
                        } else {
                            checkTempPassword (data.auth);
                        }
                        notify.yell('error', gt('Problem deleting key'));
                    })
                    .fail(function (faildata) {
                        console.log(faildata);
                    });
                }
            })
            .show(function () {
                if (!_.device('ios')) {
                    $('#deletepass').focus();
                }

            });
        });
    }

    function deleteLocalPublic (keyid) {
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Delete Public Key')));
            var body = $('<p>' + gt('Please verify you want to delete this key') + '</p>');
            dialog.getBody().append(body);
            dialog
            .addPrimaryButton('cancel', gt('Cancel'), 'cancel')
            .addButton('delete', gt('Delete'), 'delete')
            .on('delete', function () {
                deletePublic(keyid);
            })
            .show();
        });
    }

    function deletePublic (keyid) {
        var params = '';
        require (['io.ox/core/notifications'], function (notify) {
            var json = {
                userid: ox.user_id,
                cid: ox.context_id,
                keyid: keyid
            };
            core.metrics('settings', 'delete-public-key');
            http.post(ox.apiRoot + '/oxguard/pgp?action=deletelocalpublic', params, json)
            .done (function () {
                updateUserKeys();
                notify.yell('success', gt('Key Deleted'));
            })
            .fail (function () {
                notify.yell('error', gt('Failed to delete'));
            });
        });
    }

    function retractPrivate (keyid) {
        require (['io.ox/core/tk/dialogs', 'oxguard/oxguard_core', 'io.ox/core/notifications'], function (dialogs, core, notify) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'revoke' });
            dialog.header($('<h4>').text(gt('Revoke Private Key')));
            var body = $('<p>').text(gt('This will advise people not to use this key.  You can still use the key to decode existing items.'));
            var body2 = $('<p>').text(gt('Enter your password below to confirm and verify'));
            var password = passwords.createPasswordInput('revokepass');
            var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
            var reasonhead = $('<br style="line-height:2em;">' + gt('Reason') + '<br style="line-height:2em;">');
            var reason = $('<select id="revokereason" style="padding:3px;">')
                .append('<option value="NO_REASON">' + gt('No Reason') + '</option>')
                .append('<option value="KEY_SUPERSEDED">' + gt('Key superseded') + '</option>')
                .append('<option value="KEY_COMPROMISED">' + gt('Key compromised') + '</option>')
                .append('<option value="KEY_RETIRED">' + gt('Key retired') + '</option>')
                .append('<option value="USER_NO_LONGER_VALID">' + gt('User no longer valid') + '</option>');

            dialog.getBody().append(body).append(body2).append(noSaveWorkAround).append(password).append(reasonhead).append(reason);
            dialog.addPrimaryButton('revoke', gt('Revoke'), 'revoke')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('revoke', function () {
                var pass = $('#revokepass').val();
                var reason = $('#revokereason').val();
                if (pass.length > 1) {
                    core.auth(ox.user_id, pass, null, keyid)
                    .done (function (data) {
                        if (data.auth === 'Bad Password') {
                            notify.yell('error', gt('Bad Password'));
                            return;
                        }
                        if (data.auth.length > 20) {
                            var json = {
                                keyid: keyid,
                                auth: data.auth,
                                userid: ox.user_id,
                                cid: ox.context_id,
                                reason: reason
                            };
                            var params = '';
                            core.metrics('settings', 'revoke-private-key');
                            http.post(ox.apiRoot + '/oxguard/pgp?action=revokeprivkey', params, json)
                            .done (function () {
                                updateUserKeys();
                                notify.yell('success', gt('Key Revoked'));
                            })
                            .fail (function (e) {
                                notify.yell('error', gt('Failed to revoke key'));
                                console.log(e);
                            });
                            // do delete
                            return;
                        } else {
                            checkTempPassword (data.auth);
                        }
                        notify.yell('error', gt('Problem deleting key'));
                    })
                    .fail(function (faildata) {
                        console.log(faildata);
                    });
                }
            })
            .show(function () {
                if (!_.device('ios')) {
                    $('#deletepass').focus();
                }

            });
        });
    }

    function download (id) {
        var data = getCacheData (id);
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Download Key') + '   ' + data.Key));
            if (data.hasPrivate) {
                var instructions = $('<p>').append(gt('Download your private key for use with other email programs'));
                var instructions2 = $('<p>').append(gt('Do not distribute this key.  It is for your use only'));
                var downloadprivbutton = $('<button type="button" class="btn btn-primary" style="margin-bottom:17px; margin-top:8px;">' + gt('Download PGP Private Key') + '</button>');
                downloadprivbutton.click(function () {
                    downloadPrivate(data.GuardKey, false);
                    dialog.close();
                });
                var downloadbothbutton = $('<button type="button" class="btn btn-primary" style="margin-bottom:17px; margin-top:8px;">' + gt('Download Public and Private Key') + '</button>');
                downloadbothbutton.click(function () {
                    downloadPrivate(data.GuardKey, true);
                    dialog.close();
                });
                dialog.getBody().append(instructions).append(instructions2)
                .append(downloadprivbutton)
                .append(downloadbothbutton)
                .append('<br>');
            }
            var downloadbutton = $('<button type="button" class="btn btn-primary">').text(gt('Download PGP Public Key'));
            downloadbutton.on('click', function () {
                core.metrics('settings', 'download-public-key');
                var params = '&id=' + ox.user_id + '&cid=' + ox.context_id + '&keyid=' + data.GuardKey + '&session=' + ox.session;
                window.open(ox.apiRoot + '/oxguard/pgpmail/public.asc?action=getkeybyid' + params, '_blank');
                dialog.close();
            });
            dialog.getBody().append(downloadbutton);
            dialog.addPrimaryButton('cancel', gt('Cancel'), 'cancel')
            .show();
        });
    }

    function showLocalDetail (id) {
        var data = getCacheData (id);
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Key Details')));
            var resultdiv = $('<div>');
            if (data.Revoked)
                resultdiv.append('<span style="color:red;">' + gt('Revoked') + '</span><br>');

            resultdiv.append(gt('Key ID:') + ' ' + formatKeyID(data.KeyID) + '<br><br>');
            var detaildiv = $('<div style="padding-left:20px;">');
            if (data.Expires !== 'never') {
                if (data.Expired === true) {
                    detaildiv.append(gt('Expired') + '<br>');
                    detaildiv.css('color', 'red');
                } else {
                    var now = new Date();
                    var expires = new Date(now);
                    expires.setDate(now.getDate() + data.Expires);
                    detaildiv.append(gt('Expires:') + ' ' + expires.toDateString() + '<br>');
                }
            }
            detaildiv.append(gt('Private Key: ') + (data.hasPrivate ? gt('True') : gt('False')) + '<br>');
            detaildiv.append(gt('Fingerprint:') + ' ' + formatFingerprint(data.Fingerprint) + '<br>');
            detaildiv.append(gt('Created:') + ' ' + data.Created + '<br>');
            detaildiv.append(gt('Master:') + ' ' + (data.Master ? gt('True') : gt('False')) + '<br>');
            detaildiv.append(gt('Encryption:') + ' ' + (data.Encryption ? gt('True') : gt('False')) + '<br>');
            var ids = '';
            for (var j = 0; j < data.ids.length; j++) {
                if (j > 0) ids = ids + ', ';
                ids = ids + data.ids[j].replace(/>/gi,'&gt;').replace(/</gi,'&lt;');
            }
            detaildiv.append(gt('IDs: ') + ids + '<br>');
            resultdiv.append(detaildiv);
            dialog.getBody().append(resultdiv);

            dialog
                .addPrimaryButton('ok', gt('OK'), 'ok')
                .addButton('sigs', gt('Signatures'), 'sigs')
                .on('sigs', function () {
                    pubkeys.showSignatures(data.KeyLong);
                })
                .show();
        });
    }

    function getCacheData (id) {
        var indexes = id.split(',');
        var data = userKeyData[indexes[0]][indexes[1]];
        return (data);
    }

    function makeCurrent (id) {

        wait();
        var params = '&userid=' + ox.user_id + '&cid=' + ox.context_id +
        '&keyid=' + id;
        // Send the request to the oxguard server for the encrypted content key to decrypt
        core.metrics('settings', 'change-current-key');
        http.get(ox.apiRoot + '/oxguard/pgp?action=makecurrent', params)
        .done(function () {
            updateUserKeyTable ();
        })
        .fail (function (e) {
            require (['io.ox/core/notifications'], function (notify) {
                notify.yell('error', e.responseText);
                console.log(e);
                hideWait();
            });
        });

    }

    function createNew () {
        require (['oxguard/oxguard_core', 'io.ox/core/notifications', 'oxguard/core/createKeys'], function (core, notify, keys) {
            core.metrics('settings', 'create-keys-new');
            keys.createKeys()
            .done(function () {
                updateUserKeyTable();
            })
            .fail(function (e) {
                if (userKeyData.length === 0) {  // If cancelled and no keys, then reset passcode
                    window.oxguarddata.passcode = 'No Key';
                }
                if (e === 'cancel') {
                    return;
                }
                notify.yell('error', e.responseText);
            });
        });
    }

    function downloadPrivate (id, both) {
        require (['oxguard/oxguard_core', 'io.ox/core/notifications'], function (core, notify) {
            core.getPassword()
            .done (function (e) {
                core.auth(ox.user_id, e.password, null, id)
                .done (function (authdata) {
                    if (authdata.auth === 'Bad Password') {
                        notify.yell('error', gt('Bad password'));
                    }
                    if (authdata.auth === 'Lockout') {
                        notify.yell('error', gt('Account Locked out'));
                    }
                    if (authdata.auth.length > 20) {
                        /// get the key
                        core.metrics('settings', 'download-private');
                        var params = '&id=' + ox.user_id + '&cid=' + ox.context_id + '&keyid=' + id +
                        '&auth=' + encodeURIComponent(authdata.auth) +
                        '&both=' + (both ? 'true' : 'false') +
                        '&session=' + ox.session;
                        var link = ox.apiRoot + '/oxguard/pgp/private.asc?action=getprivkeybyid' + params;
                        $('#tmp').append(
                                $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'priv' })
                            );
                    } else {
                        checkTempPassword (authdata.auth);
                    }
                })
                .fail(function (data) {
                    console.log(data);
                    alert (data);
                });
            });
        });
    }

    function checkTempPassword (auth) {
        if (auth.indexOf('Password Needed') > -1) {
            require (['oxguard/core/tempPassword'], function (core) {
                core.createOxGuardPasswordPrompt();
            });
        }
    }

    // Upload users public key without private
    function uploadLocalPublic (dialog) {
        var uploadHeader = $('<div style="padding-top:10px;"/>')
        //#. %s product name
        .append('<p>' + gt('If you would like to upload a public key only, then do so here.  This will allow you to encrypt files and receive encrypted emails using %s, but you will need to use the private key with another program to decode the items.', window.oxguarddata.productName) + '</p>');
        var fileinput;
        var findfile = $('#guardFiles').find('[name="localPublicKey"]');
        if (findfile.length > 0) {
            fileinput = findfile;
        } else {
            fileinput = $('<input type="file" name="localPublicKey" style="display:none;">');
            $('#guardFiles').append(fileinput);
        }
        var uploadbutton = $('<button type="button" class="btn btn-primary">' + gt('Upload Public Key Only') + '</button>');
        uploadbutton.on('click', function () {
            fileinput.unbind('change');
            fileinput.on('change', function () {
                var files = this.files;
                if (files.length > 0) {
                    core.metrics('settings', 'upload-public-key-only');
                    require(['oxguard/pgp/uploadkeys'], function (uploader) {
                        uploader.upload(files, true)
                        .done(function () {
                            updateUserKeyTable();
                            fileinput.val('');
                        })
                        .fail(function () {
                            fileinput.val('');
                        });
                    });
                }
            });
            fileinput.click();
            dialog.close();
        });
        uploadHeader.append(uploadbutton);
        return (uploadHeader);
    }

    // Send public key by email
    function sendPublic () {
        // Create a wait div
        wait();
        var params = '&id=' + ox.user_id + '&cid=' + ox.context_id;
        http.get(ox.apiRoot, '/oxguard/pgpmail/public.asc?action=getkeybyid' + params)
        .done(function (data) {
            if (data === null) {
                fail (gt('Unable to get key'));
            }
            if (data.indexOf('BEGIN PGP') > -1) { // Verify PGP structure
                var body = {
                    content: gt('PGP Public Key is attached'),  // Content of email body
                    content_type: 'text/plain',
                    disp: 'inline',
                    id: 1,
                    size: 0
                };
                var attach = { // Attach the pgp data as attachment
                    content: data,
                    content_type: 'text/plain',
                    disp: 'attachment',
                    size: data.length,
                    filename: 'public.asc',
                    type: 'asc',
                    group: 'attachment',
                    raw: true
                };
                var attachments = [body, attach];
                core.metrics('settings', 'send-public-key-by-mail');
                ox.registry.call('mail-compose', 'compose', { attachments: attachments })
                .done(function () {
                    hideWait();
                })
                .fail(function (e) {
                    fail (e.responseText);
                    hideWait();
                });
            } else {
                hideWait();
                fail (data);
            }
        })
        .fail(function (e) {
            hideWait();
            fail (e.responseText);
        });
    }

    // General fail call to display error message
    function fail (message) {
        require(['io.ox/core/notifications'], function (notify) {
            notify.yell('error', message);
        });
    }

    function formatKeyID (id) {
        if (id.length < 9) return (id);
        return ('<span class="keystart">' + id.substring(0,(id.length - 8)) + '</span><span class="keyend">' + id.substring((id.length - 8)) + '</span>');
    }

    function formatFingerprint (fp) {
        if (fp.length < 28) return (fp);
        var line1 = fp.substring (0,24);
        var line2 = fp.substring (25);
        return ('<span style="float:right;">' + line1 + '</span><br/><span style="float:right">' + line2 + '</span>');
    }

    ///// Public Key section
    function uploadPublic () {
        var uploadHeader = $('<div class="oxguard_settings keys"/>')
        .append('<legend class="sectiontitle">' + gt('Public Keys') + '</legend>');
        return (uploadHeader);
    }

    ///   Defaults section

    function sendDefaults() {
        var defaultChecked = $('#pgpdefault').is(':checked');
        var defaultinline = $('#inlinedefault').is(':checked');
        var pgpsign = $('#pgpsign').is(':checked');
        var encryptIncoming = $('#encrIncoming').is(':checked');
        var data = {
            pgpdefault: defaultChecked,
            inline: defaultinline,
            pgpsign: pgpsign,
            encryptIncoming: encryptIncoming
        };
        window.oxguarddata.settings = _.extend(window.oxguarddata.settings, data);
        var json = {
            id: ox.user_id,
            cid: ox.context_id,
            data: data
        };
        http.post(ox.apiRoot + '/oxguard/settings?action=set', '', json)
        .fail (function () {
            require(['io.ox/core/notifications'], function (notify) {
                notify.yell('error', gt('Failed to update settings'));
            });
        });
    }

    function updateCheckboxes () {
        if (window.oxguarddata.settings !== undefined) {
            if (window.oxguarddata.settings.pgpdefault) {
                $('#pgpdefault').prop('checked', true);
            } else {
                $('#pgpdefault').prop('checked', false);
            }
            if (window.oxguarddata.settings.inline) {
                $('#inlinedefault').prop('checked', true);
            } else {
                $('#inlinedefault').prop('checked', false);
            }
            if (window.oxguarddata.settings.pgpsign) {
                $('#pgpsign').prop('checked', true);
            } else {
                $('#pgpsign').prop('checked', false);
            }
            if (window.oxguarddata.settings.encryptIncoming) {
                $('#encrIncoming').prop('checked', true);
            } else {
                $('#encrIncoming').prop('checked', false);
            }
            if (settings.get('advanced')) {
                $('#pgpadvanced').prop('checked', true);
            } else {
                $('#pgpadvanced').prop('checked', false);
            }
        }
        if (settings.get('defRemember')) {
            $('#defrem').val(settings.get('defRemember'));
        } else {
            $('#defrem').val('0');
        }
    }

    function switchEmailType () {
        if ($('#inlinedefault').is(':checked')) {
            require (['settings!io.ox/mail'], function (s) {
                if (s.get('messageFormat') !== 'text') {
                    var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter: 'ok' });
                    dialog.header($('<h4>').text(gt('Email format')));
                    var instructions = $('<p>').append(gt('Emails that contain HTML and are sent with PGP Inline will often result in decoding errors and possible failure.  As a result, the default Email format should be changed to plaintext.  Click OK to change the default to plaintext, cancel to keep your current setting.'));
                    dialog.getBody().append(instructions);
                    dialog
                    .addPrimaryButton('ok', gt('OK'), 'ok')
                    .addButton('cancel', gt('Cancel'), 'cancel')
                    .on('ok', function () {
                        s.set('messageFormat', 'text');
                        s.save();
                    })
                    .show();
                }
            });
        }
    }

    function defaults () {
        var defaultsHeader = $('<div class="oxguard_settings defaults" style="line-height: 1.8em;"/>');
        var rememberDefault = $('<div class="row" style="padding-bottom:10px;">');
        var remPass = $('<select id="defrem" class="form-control">' +
                '<option value="0">' + gt('Ask each time') + '</option>' +
                '<option value="10">' + gt('10 minutes') + '</option>' +
                '<option value="20">' + gt('20 minutes') + '</option>' +
                '<option value="30">' + gt('30 minutes') + '</option>' +
                '<option value="60">' + gt('1 hour') + '</option>' +
                '<option value="120">' + gt('2 hours') + '</option>' +
                '<option value="99999">' + gt('Session') + '</option' +
                '</select>')
                .on('change', function (e) {
                    if (e.target.value === 0) {
                        settings.clear('defRemember');
                    } else {
                        settings.set('defRemember', e.target.value);
                        settings.save();
                    }
                });
        rememberDefault.append('<label for="defrem" class="control-lobal col-sm-4">' + gt('Remember Password Default') + '</label>')
        .append($('<div class="col-sm-4">').append(remPass));
        var makePGPdefault = $('<input type="checkbox" id="pgpdefault" style="margin-right:15px; margin-top:1px;">');
        var optiondiv = $('<div>');
        var defdiv = $('<label class="selectable" for="pgpdefault">' + gt('Default to send encrypted when composing email') + '</span></br>');
        defdiv.click(function () {
            makePGPdefault.click();
        });
        var encrDefault =  $('<input type="checkbox" id="encrIncoming" style="margin-right:15px; margin-top:1px;">');
        var encrDiv = $('<label class="selectable" for="encrIncoming">' + gt('Encrypt all incoming emails') + '</span></br>');
        encrDiv.click(function () {
            encrDefault.click();
        });
        var pGPSigndefault = $('<input type="checkbox" id="pgpsign" style="margin-right:15px; margin-top:1px;">');
        var sigdiv = $('<label class="selectable" for="pgpsign">' + gt('Default adding signature to outgoing mails') + '</span></br>');
        sigdiv.click(function () {
            pGPSigndefault.click();
        });
        var typediv = $('<label class="selectable" for="inlinedefault">' + gt('Default to using PGP inline for new mails') + '</span></br>');
        var pgpType = $('<input type="checkbox" id="inlinedefault" style="margin-right:15px; margin-top:1px;">');
        typediv.click(function () {
            pgpType.click();
        });
        optiondiv.append(rememberDefault).append(makePGPdefault).append(defdiv).append(pGPSigndefault).append(sigdiv);
        if (settings.get('advanced') || window.oxguarddata.settings.inline) {
            if (settings.get('enableEncryptIncoming')) optiondiv.append(encrDefault).append(encrDiv);
            optiondiv.append(pgpType).append(typediv);
        }
        makePGPdefault.click(function () {
            sendDefaults();
        });
        encrDefault.click(function () {
            sendDefaults();
        });
        pgpType.click(function () {
            sendDefaults();
            switchEmailType();
        });
        pGPSigndefault.click(function () {
            sendDefaults();
        });
        return (defaultsHeader.append(optiondiv));
    }

    //// Generic wait
    function setupWait () {
        var waitdiv = $('<div class="og_wait" id="og_wait" style="display:none;"></div');
        waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Please wait') + '</span>');
        $('.window-container-center').append(waitdiv);
    }
    function wait () {
        $('#og_wait').show();
    }
    function hideWait () {
        $('#og_wait').hide();
    }

    function drawAdvanced () {
        var header = $('<legend class="sectiontitle" style="margin-bottom:5px;">').append(gt('Advanced'));
        var defaultsHeader = $('<div class="oxguard_settings defaults" style="line-height: 1.8em;"/>');
        var useAdvanced = $('<input type="checkbox" id="pgpadvanced" class="pgpadvanced" style="margin-right:15px; margin-top:1px;">');
        var optiondiv = $('<div>');
        var advdiv = $('<label for="pgpadvanced" class="selectable pgpadvanced">' + gt('Enable Advanced PGP Features') + '</span></br>');
        advdiv.click(function () {
            useAdvanced.click();
        });
        useAdvanced.on('click', function () {
            if ($('#pgpadvanced').is(':checked')) {
                core.metrics('settings', 'select-advanced-mode');
            } else {
                core.metrics('settings', 'select-basic-mode');
            }
            settings.set('advanced', $('#pgpadvanced').is(':checked'));
            settings.save();
            redraw();
        });
        optiondiv.append(useAdvanced).append(advdiv);
        return (defaultsHeader.append(header).append(optiondiv));
    }

    function drawVersion () {
        if (_.device('small')) return ('');
        var div = $('<div class="guardVersion">');
        div.append(window.oxguarddata.version + '<br>build: ' + window.oxguarddata.server);
        return (div);
    }
    ///// Setup

    ext.point('oxguard/pgp/settings/detail').extend({
        index: 203,
        id: 'oxguardppgsettings',
        draw: function () {
            var node = this;
            thisNode = this;
            util.hasSetupDone()
            .done(function () {
                if (settings.get('cryptoProvider') === 'mailvelope') {
                    require (['mailvelope/settings/pane'], function (mv) {
                        mv.drawAdvancedSettings($(node));
                    });
                    return;
                }
                node.append(addSettings());
            })
            .fail(function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard' }).done(function () {
                    this.setSettingsPane({ id: 'oxguard' });
                });
            });
        },
        save: _.noop
    });

    function redraw() {
        thisNode.empty();
        thisNode.append(addSettings());
    }

    function addSettings () {
        var holder = $('<div>').css('max-width', '800px');
        var message = $('<span>').append((settings.get('advanced') ? gt('PGP Encryption Settings') : gt('Security Settings')));
        message.append(new HelpView({
            base: 'help-guard',
            iconClass: 'guardhelp',
            href: 'ox.guard.user.sect.usage.settings.pgp.html',
            tabindex: '-1'
        }).render().$el);
        var header = $('<h1>').append(message);
        holder.append(header);
        holder.append('<div id="guardFiles">');
        window.setTimeout (function () {
            updateCheckboxes ();
        }, 20);
        setupWait();
        var settingsDiv = holder.append(defaults).append(keys());
        if (settings.get('advanced')) {
            settingsDiv.append(uploadPublic().append(pubkeys.listPublic('settings')));
        }
        settingsDiv.append(drawAdvanced()).append(drawVersion());
        return (settingsDiv);
    }
});
