/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/pgp/settings', [
    'io.ox/core/extensions',
    'io.ox/core/folder/api',
    'gettext!oxguard',
    'settings!oxguard'
], function (ext, folderAPI, gt, settings) {
    'use strict';

    var point = ext.point('io.ox/settings/pane/main/oxguard');

    settings.on('change:cryptoProvider', updateExtensions);

    function updateExtensions (m, provider) {
        if (provider !== 'guard') {
            point.disable('oxguard/pgp');
        } else {
            point.enable('oxguard/pgp');
        }
    }

    function initAdvancedSettings() {
        var provider = settings.get('cryptoProvider');

        point.extend({
            //#. %s product name
            title: gt('Advanced Settings'),
            id: 'oxguard/pgp',
            loadSettingPane: true,
            index: 100
        });

        updateExtensions(settings, provider);
    }

    initAdvancedSettings();

});
