/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/pgp/mailReplyActions', [
], function () {
    'use strict';

    ox.on('mail:reply:ready', checkReply);
    ox.on('mail:replyall:ready', checkReply);
    ox.on('mail:forward:ready', checkReply);
    ox.on('mail:edit:ready', checkEdit);

    // If loading a draft email, need to set security settings same as before
    function checkEdit (obj, app) {
        if (obj.headers && obj.headers['X-Security']) {
            var reply = obj.headers['In-Reply-To'] !== undefined;  // If this is editing a reply
            var securitySettings = _.isArray(obj.headers['X-Security']) ? obj.headers['X-Security'][0] : obj.headers['X-Security'];
            var settings = securitySettings.split(';');
            var security = app.model.get('security');
            settings.forEach(function (setting) {
                var s = setting.split('=');
                var value = (s[1] ? (s[1].indexOf('true') > -1) : false);
                switch (s[0].trim()) {
                case 'sign':
                    app.model.set('PGPSignature', value);
                    security.sign = value;
                    break;
                case 'encrypt':
                    app.model.set('encrypt', value);
                    security.encrypt = value;
                    if (value === true && reply) {  // Check if we should enforce the secure reply here
                        if (window.oxguarddata.settings && window.oxguarddata.settings.secureReply) {
                            app.view.toggleEncryption.forceEncryption();
                        }
                    }
                    break;
                case 'pgpInline':
                    if (security.encrypt) app.model.set('PGPFormat', (value ? 'inline' : 'mime'));
                    security.pgpInline = value;
                    break;
                }
            });
            if (obj.security.authentication) {
                security.authentication = obj.security.authentication;
            }
            app.model.set('security', security);
            app.model.unset('security_info');
        }
    }

    // When doing reply/forward, check essential security data moved to new model
    function checkReply (obj, app) {
        if (obj.security && obj.security.decrypted) {
            app.model.set('encrypt', true);
            if (obj.security.authentication) {
                app.model.set('security', _.extend(app.model.get('security'), { authentication: obj.security.authentication }));
            }
            require(['oxguard/util'], function (util) {
                if (!util.hasGuardMailCapability()) {
                    app.view.toggleEncryption.forceEncryption();
                    disableRecipients(app.view);
                }
            });
            if (window.oxguarddata.settings && window.oxguarddata.settings.secureReply) {
                app.view.toggleEncryption.forceEncryption();
            }
        }
        app.model.unset('security_info');
    }

    function disableRecipients (view) {
        view.$el.find('.recipient-actions').remove();
        view.$el.find('.tokenfield').css('background-color', '#e0e0e0');
        view.$el.find('.token-input').click(function (e) {
            $(e.currentTarget).blur();
            e.preventDefault();
            require(['gettext!oxguard', 'io.ox/core/notifications'], function (gt, notify) {
                notify.yell('error', gt('Recipients cannot be added to this encrypted reply'));
            });
        });
    }

});
