/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/mail/oxguard_mail_password', [
    'io.ox/core/extensions',
    'oxguard/oxguard_core',
    'oxguard/core/og_http',
    'oxguard/core/passwords',
    'gettext!oxguard',
    'settings!oxguard'
], function (ext, oxguard, http, passwords, gt, guardSettings) {
    'use strict';

    var encrPrivKey = '';

    ////////////////////////   RECEIVE / READ

    function loadKeyClick(evt) {
        var file = evt.target.files[0];
        var reader = new FileReader();

        reader.onload = function (event) {
            encrPrivKey = event.target.result;
            $('#privKeyButton').html(gt('Loaded'));
        };
        reader.readAsText(file);
    }

    // Unified inbox combines folder and email ID, returns email id
    function getId(baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1) + (baton.view.cid ? baton.view.cid : '');
        } catch (e) {}
        return (id);
    }

    function passwordPrompt(baton, badpass, location, goFunction) {
        var id = getId(baton);
        var grdPasswordPrompt = $('<div class="alert og_password"/>');
        //#. %s product Name
        var mainpassprompt = $('<label for="oxgrpass' + id + '" style="font-weight:bold;">' + gt('Secure Email, enter your %s security password.', window.oxguarddata.productName) + '</span><div style="height:10px;"/>');
        var passwordbox = passwords.createPasswordInput('oxgrpass' + id, 'oxgrpass' + id,  'style="margin-bottom:10px;margin-top:7px;max-width:100%"');
        if (_.device('small')) {
            passwordbox.css('width', '150px');
        }
        var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
        var passButton = $('<button class="btn btn-primary oxguard_passbutton" type="button">' + gt('OK') + '</button><br/>');
        var placeholder = $('<span></span><br/>');
        //#. 'Keep me logged into guard' is followed by dropdown box specifying number of minutes or indefinite, %s product name
        var remembertext = $('<span class="selectable">&nbsp ' + gt('Keep me logged into %s', window.oxguarddata.productName) + '</span><br/>');
        var checkbox = $('<input type="checkbox" name="rememberpass' + id + '" value="true" style="margin-top:-3px;"/>');
        var rememberpass = $('<div>').append(checkbox);
        var duration = $('<select id="duration' + id + '" class="og_duration"><option value="10">' + gt('10 minutes') + '</option>' +
                '<option value="20">' + gt('20 minutes') + '</option>' +
                '<option value="30">' + gt('30 minutes') + '</option>' +
                '<option value="60">' + gt('1 hour') + '</option>' +
                '<option value="120">' + gt('2 hours') + '</option>' +
                '<option value="99999">' + gt('Session') + '</option' +
                '</select>')
                .on('change', function () {
                    $('input[name="rememberpass' + id + '"]').prop('checked', true);
                });
        if (guardSettings.get('defRemember')) {
            duration.val(guardSettings.get('defRemember'));
            if (guardSettings.get('defRemember') !== '0') checkbox.prop('checked', true);
        }
        rememberpass.append(remembertext).append(duration);
        remembertext.click(function () {
            $('[name="rememberpass' + id + '"]').click();
        });

        var cont = $('<br/><div class="oxguard_error" id = "error' + id + '" style="display:none;"><i class="fa fa-spinner fa-spin" id="busygif"></i></div>');
        if (window.oxguarddata.passcode === 'NoPrivate') {
            var btn = $('<button class="btn og_getkey" id="privKeyButton' + id + '">' + gt('Select Key Location') + '</button>');

            var input = $('<input type="file" id="files' + id + '" name="files[] style="padding:10px;visibility:hidden;position:absolute;top-50px;left:-50px;"/>');
            btn.click(function () {
                input.click();
            });
            input.change(function (evt) {
                loadKeyClick(evt);
            });
            placeholder.append(btn.after(input));
        }
        passButton.click(function () {
            go();
        });
        passwordbox.keypress(function (e) {
            if (e.which === 13) {
                // passButton.click();
                go();
            }
        });
        var mainprompt = (window.oxguarddata.passcode === null) || badpass || (window.oxguarddata.passcode === 'NoPrivate');
        if (mainprompt) {
            grdPasswordPrompt.append(noSaveWorkAround).append(mainpassprompt).append(passwordbox).append(passButton).append(placeholder).append(rememberpass).append(cont);
            window.setTimeout(function () {
                passwordbox.removeAttr('readonly');
            }, 500);
        }

        function go() {
            $('#error' + id).show();
            var password = ($('#oxgrpass' + id).val() === undefined) ? '' : $('#oxgrpass' + id).val();
            var password = $('#oxgrpass' + id).val();
            var duration = -1;
            if ($('input[name="rememberpass' + id + '"]').is(':checked')) {
                duration = $('#duration' + id).val();
            }
            oxguard.savePassword (password, duration)
            .done(function () {
                goFunction (id);
            })
            .fail(function (data) {
                $('#busygif').hide();
                require (['io.ox/core/notifications'], function (notifications) {
                    if (data.auth.indexOf('Lockout') > -1) {
                        notifications.yell('error', gt('Temporary Lockout'));
                    } else {
                        //#. Bad, incorrect password
                        notifications.yell('error', gt('Bad password'));
                    }
                });
            });
        }
        var contdiv = $('<div class="content" id = "content' + id + '"/>').append(grdPasswordPrompt);
        return (contdiv);
    }

    return {
        passwordPrompt: passwordPrompt,
        getId: getId
    };
});
