/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/mail/oxguard_mail_compose_core', [
    'io.ox/core/extensions',
    'oxguard/core/og_http',
    'io.ox/core/notifications',
    'oxguard/util',
    'settings!oxguard',
    'io.ox/core/tk/dialogs', 'gettext!oxguard'
], function (ext, og_http, notify, util, settings, dialogs, gt) {
    'use strict';

    //#. %s product name
    var guesticon = '<i id="newguest" class="fa fa-male oxguard_token" style="color:#5DCD55;" title="' + gt('Will create new guest account for %s', window.oxguarddata.productName) + '"/>';
    //#. Have encryption key - Shown on icon hover when a key symbol is displayed for recipient.  We/Guard have an encryption key for the recipient.
    var keyicon = '<i class="fa fa-key oxguard_token oxguard_lock" aria-hidden="true" title="' + gt('Encryption Key Known') +'"></i>';
    //#. %s product name
    var failicon = '<i id="newguest" class="fa fa-ban oxguard_token" style="color:red;" title="' + gt('Will create new guest account for %s', window.oxguarddata.productName) + '"/>';
    var prompting = false;

    // 7.8 compose code

    function drawKeyIcons(result, location) {
        var input = $(location).parent().find('.token-input');
        var inputwidth = input.width() - 30;
        switch (result) {
        case 'pgp' :
            $(location).find('.close').before(keyicon);
            break;
        case 'guest' :
            $(location).find('.close').before(guesticon);
            break;
        case 'fail' :
            $(location).find('.close').before(failicon);
            break;
        }
        input.width(inputwidth);
    }

    // Return a has of string
    function hash(str) {
        var hashed = 0;
        if (str.length === 0) return hashed;
        for (var i = 0; i < str.length; i++) {
            hashed = (31 * hashed + str.charCodeAt(i)) << 0;
        }
        return hashed;
    }

    function checkrecipient(baton) {
        if (!util.isGuardConfigured()) {
            if (!prompting) {
                prompting = true;
                require(['oxguard/oxguard_core', 'oxguard/core/createKeys'], function (core, keys) {
                    core.metrics('mail', 'create-keys-from-compose');
                    keys.createKeysWizard()
                    .done(function () {
                        checkrecipient(baton);
                    })
                    .fail(function () {
                        unlock(baton);
                    })
                    .always(function () {
                        prompting = false;
                    });
                });
            }
            return;// Do not check recipients until the master key is created (in case mailing to self)
        }
        require(['oxguard/mail/keymanager'], function (keyman) {
            keyman.checkAll(baton);
        });
    }

    function unlock(baton) {
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html(gt('Send'));
        } else {
            var headerview = baton.view.app.get('window').nodes.header;
            var footerview = baton.view.app.get('window').nodes.footer;
            headerview.find('.btn-primary:visible').html(gt('Send'));
            if (footerview) {
                footerview.find('.btn-primary:visible').html(gt('Send'));
            }
        }
        baton.view.$el.find('.oxguard_key').hide();
        baton.view.$el.find('.oxguard_token').hide();
        baton.view.model.set('encrypt', false);
        var security = baton.view.model.get('security');
        security.encrypt = false;
        baton.view.model.set('security', security);
        var format = baton.view.model.get('PGPFormat');
        if (format === 'inline' || format === 'i') {  // Deactivate the Format types if not encrypted
            baton.view.model.set('PGPFormat', 'i');
        } else {
            baton.view.model.set('PGPFormat', 'm');
        }
    }

    function lock(baton) {

        var security = baton.view.model.get('security');
        security.encrypt = true;
        baton.view.model.set('security', security);
        if (_.device('smartphone')) {
            $('.btn-primary:visible').html((settings.get('advanced') ? gt ('Send Encrypted') : gt('Send Secure')));
        } else {
            var headerview = baton.view.app.get('window').nodes.header;
            var footerview = baton.view.app.get('window').nodes.footer;
            headerview.find('.btn-primary:visible').html((settings.get('advanced') ? gt ('Send Encrypted') : gt('Send Secure')));
            if (footerview) {
                footerview.find('.btn-primary:visible').html((settings.get('advanced') ? gt ('Send Encrypted') : gt('Send Secure')));
            }
        }
        checkrecipient(baton);
        baton.view.$el.find('.oxguard_key').show();
        baton.view.$el.find('.oxguard_token').show();
        baton.view.model.set('encrypt', true);
        var format = baton.view.model.get('PGPFormat');
        if (format === 'i') {  // Activate the Format types if encrypted
            baton.view.model.set('PGPFormat', 'inline');
        } else {
            if (format === 'm') baton.view.model.set('PGPFormat', 'mime');
        }
    }

    return {
        lock: lock,
        hash: hash,
        unlock: unlock,
        drawKeyIcons: drawKeyIcons
    };
});
