/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/core/tempPassword', [
    'io.ox/core/tk/dialogs',
    'oxguard/core/og_http',
    'oxguard/oxguard_core',
    'settings!oxguard',
    'gettext!oxguard'
], function (dialogs, http, core, settings, gt) {
    'use strict';

    var firstprompt = false;

    // Prompt for initial password change
    function createOxGuardPasswordPrompt(baton, go, errors, oldpass, index) {
        if (firstprompt) return;
        firstprompt = true;
        var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter: 'okpass' });
        var isnew = window.oxguarddata['new'];
        var explain = '';
        if (isnew) {
            //#. %s product name
            dialog.header($('<h4>').text(gt('First %s Security Use', window.oxguarddata.productName)));
            explain  = $('<div>');
            explain.append($('<p>').append(gt('You have been sent an email using %s to secure the contents', window.oxguarddata.productName)));
            explain.append($('<p>').append(gt('Please select a new password for use with %s.  This password will be used to open encrypted emails and files that may be sent to you.', window.oxguarddata.productName)));
        } else {
            //#. %s product name
            dialog.header($('<h4>').text(gt('First %s Security Password Use', window.oxguarddata.productName)));
            explain = $('<div><p>' + gt('Please change the initial temporary %s security password that was sent to you in a separate email.', window.oxguarddata.productName) + '</p></div>');
        }

        var passdiv = $('<div>').addClass('row-fluid');
        var newogpassword = $('<input name="newogpassword" type="password" autocomplete="off"/>');
        var td1 = $('<td>').append(newogpassword);
        var newogpassword2 = $('<input name="newogpassword2" type="password" autcomplete="off"/>');
        var td2 = $('<td>').append(newogpassword2);
        var hint = $('<td>');
        var table = $('<table class="og_password_prompt"/>');
        if (!isnew) {
            table
            .append('<tr><td class="pw"><em>' + gt('Initial Password') + ':</em></td><td><input name="oldogpassword" type="password" autocomplete="off"/></td></tr>');
        }
        table
        .append($('<tr><td class="pw"><em>' + gt('New Password') + ':</em></td></tr>').append(td1).append(hint))
        //#. Confirm new password
        .append($('<tr><td class="pw"><em>' + gt('Confirm New') + ':</em></td></tr>').append(td2).append('<td></td>'));
        passdiv.append(table);
        dialog.getBody().append(explain).append(passdiv);
        require (['oxguard/core/passwords'], function (pass) {
            pass.passwordCheck(newogpassword, hint);
            pass.passwordCompare(newogpassword2, newogpassword, hint);
        });
        if (window.oxguarddata.settings.noRecovery !== true) {
            var rule = $('<hr/>');
            var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password.' + '</p>'));

            var table2 = $('<table class="og_password_prompt"/>');
            var email1 = $('<input name="recoveryemail"/>');
            var email2 = $('<input name="verifyemail"/>');
            var hint2 = $('<td>');
            var row = $('<tr>').append($('<td class="pw"><em>' + gt ('Email:') + '</em></td>')).append($('<td>').append(email1)).append(hint2);
            var row2 = $('<tr>').append($('<td class="pw"><em>' + gt ('Verify:') + '</em></td>')).append($('<td>').append(email2));
            table2.append(row).append(row2);
            dialog.getBody().append(rule).append(recovery).append(table2);
            require (['oxguard/core/emailverify'], function (verify) {
                verify.setValidate(email1, hint2);
                verify.autoCompare(email1, email2, hint2);
            });
        } else {
            var warning = $('<p>').append($('<b>').append(gt('Warning: This password for encryption cannot be restored or recovered in any way.  If forgotten, all encrypted data will be lost.')));
            dialog.getBody().append($('<hr/>')).append(warning);
        }
        if (errors !== undefined) {
            dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
        }
        dialog
        .addPrimaryButton('okpass', gt('OK'), 'okpass')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('cancel', function () {
            firstprompt = false;
        })
        .on('okpass', function () {
            firstprompt = false;
            var oldpass = $('input[name="oldogpassword"]').val() === undefined ? '' : $('input[name="oldogpassword"]').val();
            var pass1 = $('input[name="newogpassword"]').val();
            var pass2 = $('input[name="newogpassword2"]').val();
            var emailaddr = $('input[name="recoveryemail"]').val() === undefined ? '' : $('input[name="recoveryemail"]').val();
            var verify = $('input[name="verifyemail"]').val() === undefined ? '' : $('input[name="verifyemail"]').val();
            if (emailaddr !== verify) {
                $('input[name="verifyemail"]').css('background-color', 'salmon');
                createOxGuardPasswordPrompt(baton, go, gt('Emails not equal'), oldpass);
                return;
            }
            if (pass1 !== pass2) {
                $('input[name="newogpassword2"]').css('background-color', 'salmon');
                createOxGuardPasswordPrompt(baton, go, gt('Passwords not equal'), oldpass);
                return;
            }
            var userdata = {
                newpass: pass1,
                oldpass: oldpass,
                email: emailaddr,
                user_id: ox.user_id,
                sessionID: ox.session,
                cid: ox.context_id
            };
            if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                createOxGuardPasswordPrompt(baton, go, gt('Enter new secondary Email address'), oldpass);
                return;
            }
            if (validateEmail(emailaddr)) userdata.email = emailaddr;
            require (['io.ox/core/notifications'], function (notifications) {
                http.post(ox.apiRoot + '/oxguard/login?action=changepass', '', userdata)
                .done(function (data) {
                    if (typeof data === 'string') data = $.parseJSON(data);
                    if (data.auth === undefined) {
                        require(['oxguard/core/errorHandler'], function (err) {
                            err.showError(data);
                        });
                        return;
                    }
                    if (data.auth.length > 20) {
                        $('#grdsettingerror').text(gt('Success'));
                        $('input[name="newogpassword"]').val('');
                        $('input[name="newogpassword2"]').val('');
                        window.oxguarddata.passcode = null;
                        window.oxguarddata.recoveryAvail = window.oxguarddata.recovery = !window.oxguarddata.settings.noRecovery;
                        core.saveAuthToSession(data.auth, -1).then(function () {
                            go (baton, pass1, index);
                        });
                        notifications.yell('success', gt('Password changed successfully'));
                        updateSecondary();
                        // Here we want to set the cryptoProvider to Guard to avoid confusion with setup later
                        settings.set('cryptoProvider', 'guard').save();
                        window.oxguarddata['new'] = false;
                        // Complete, now offer tour
                        require(['io.ox/core/capabilities', 'io.ox/core/tk/wizard', 'oxguard/tour/main'], function (capabilities, Tour) {
                            if (capabilities.has('guard-mail')) { // only run tour if has guard-mail
                                Tour.registry.get('default/oxguard/createKeys').get('run')();
                            }
                        });

                    } else {
                        if (data.auth === 'Bad new password') {
                            notifications.yell('error', gt('New password must be at least %s characters long', data.minlength));
                            return;
                        }
                        if (data.auth === 'Bad password') {
                            //#. Bad, incorrect password
                            notifications.yell('error', gt('Bad password'));
                            return;
                        }
                        if (data.auth === 'Key not found') {
                            notifications.yell('error', gt('Encryption key not found'));
                            return;
                        }
                        notifications.yell('error', gt('Failed to change password'));
                    }
                })
                .fail(function () {
                    notifications.yell('error', gt('Failed to change password'));
                });
            });
        })
        .show(function () {
            if (oldpass !== undefined) {
                $('input[name="oldogpassword"]').val(oldpass);
                if (!_.device('ios')) {
                    $('input[name="newogpassword"]').focus();
                }
            } else
                if (!_.device('ios')) {
                    $('input[name="oldogpassword"]').focus();
                }
            window.setTimeout(function () {
                var j = 0;
                $('.pw').each(function (i,v) {
                    var w = $(v).width();
                    if (w > j) j = w;
                });
                $('.pw').each(function (i,v) {
                    $(v).width(j);
                });
                var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                email.on('keyup', function () {
                    if (validateEmail(email.val())) {
                        email.css('background-color', 'white');
                    } else {
                        email.css('background-color', 'rgb(253, 187, 179)');
                    }
                });
            },0);
        });
    }

    // Valide legit email address
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    function updateSecondary () {
        if ($('#currentsecondary').length > 0) {
            require (['oxguard/settings/pane'], function (settingsPage) {
                settingsPage.updateEmail();
            });
        }
    }

    return {
        createOxGuardPasswordPrompt: createOxGuardPasswordPrompt
    };

});
