/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/core/errorHandler', [
    'io.ox/core/notifications'
], function (notify) {
    'use strict';

    function showError (json) {
        if (json[0] !== undefined) json = json[0];
        if (json.error) {
            if (json.error_desc) {
                notify.yell('error', json.error);
                return;
            }
            notify.yell('error', json.error);
        }
    }

    return {
        showError: showError
    };
});
