Name:           open-xchange-guard-help
BuildArch:      noarch
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
%if 0%{?suse_version}
BuildRequires:  nodejs6
BuildRequires:  npm6
%else
BuildRequires:  nodejs >= 0.10.0
%endif
Version:        2.8.0
%define         ox_release 22
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
Vendor:         Open-Xchange
URL:            http://open-xchange.com
Packager:       Marcus Klein <marcus.klein@open-xchange.com>
License:        CC-BY-NC-SA
Summary:        OX Guard online help
Source:         %{name}_%{version}.orig.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html/
%else
%define docroot /srv/www/htdocs/
%endif

%description
OX Guard help files

%package        common
Group:          Applications/Productivity
Summary:        Language-independent files of online help for OX Guard

%description    common
Language-independent files of online help for OX Guard

%package       de-de
Group:         Applications/Productivity
Summary:       Online help for OX Guard (de_DE)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   de-de
Online help for OX Guard (de_DE)

%package       en-gb
Group:         Applications/Productivity
Summary:       Online help for OX Guard (en_GB)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   en-gb
Online help for OX Guard (en_GB)

%package       en-us
Group:         Applications/Productivity
Summary:       Online help for OX Guard (en_US)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   en-us
Online help for OX Guard (en_US)

%package       es-es
Group:         Applications/Productivity
Summary:       Online help for OX Guard (es_ES)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   es-es
Online help for OX Guard (es_ES)

%package       es-mx
Group:         Applications/Productivity
Summary:       Online help for OX Guard (es_MX)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   es-mx
Online help for OX Guard (es_MX)

%package       fr-fr
Group:         Applications/Productivity
Summary:       Online help for OX Guard (fr_FR)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   fr-fr
Online help for OX Guard (fr_FR)

%package       it-it
Group:         Applications/Productivity
Summary:       Online help for OX Guard (it_IT)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   it-it
Online help for OX Guard (it_IT)

%package       ja-jp
Group:         Applications/Productivity
Summary:       Online help for OX Guard (ja_JP)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   ja-jp
Online help for OX Guard (ja_JP)

%package       nl-nl
Group:         Applications/Productivity
Summary:       Online help for OX Guard (nl_NL)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   nl-nl
Online help for OX Guard (nl_NL)

%package       pl-pl
Group:         Applications/Productivity
Summary:       Online help for OX Guard (pl_PL)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   pl-pl
Online help for OX Guard (pl_PL)

%package       zh-cn
Group:         Applications/Productivity
Summary:       Online help for OX Guard (zh_CN)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   zh-cn
Online help for OX Guard (zh_CN)

%package       zh-tw
Group:         Applications/Productivity
Summary:       Online help for OX Guard (zh_TW)
Provides:      open-xchange-guard-help
Requires:      open-xchange-guard-help-common

%description   zh-tw
Online help for OX Guard (zh_TW)

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -Dhtdoc=%{docroot} -Dlanguages=false -DkeepCache=true -f build/build.xml build
for LANG in de_DE en_GB en_US es_ES es_MX fr_FR it_IT ja_JP nl_NL pl_PL zh_CN zh_TW; do
    ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -Dhtdoc=%{docroot} -DinstallTarget=${LANG} -DkeepCache=true -Dnoclean=true -f build/build.xml clean build
done

%clean
%{__rm} -rf %{buildroot}

%files common
%defattr(-,root,root)
%dir %{docroot}/appsuite
%{docroot}/appsuite/help-guard
%exclude %{docroot}/appsuite/help-guard/l10n

%files de-de
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/de_DE

%files en-gb
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/en_GB

%files en-us
%defattr(-,root,root)
%dir %{docroot}/appsuite
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/en_US

%files es-es
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/es_ES

%files es-mx
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/es_MX

%files fr-fr
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/fr_FR

%files it-it
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/it_IT

%files ja-jp
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/ja_JP

%files nl-nl
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/nl_NL

%files pl-pl
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/pl_PL

%files zh-cn
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/zh_CN

%files zh-tw
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-guard/l10n
%{docroot}/appsuite/help-guard/l10n/zh_TW

%changelog
* Tue Jun 04 2019 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2019-06-11 (5265)
* Tue Dec 11 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-12-17 (5025)
* Thu Oct 18 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-10-22 (4929)
* Fri Oct 05 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-10-10 (4910)
* Tue Jun 26 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-07-02 (4804)
* Wed May 09 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-05-14 (4742)
* Tue Apr 17 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-04-23 (4648)
* Fri Mar 23 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-03-28 (4610)
* Mon Feb 12 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-02-05
* Mon Jan 08 2018 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2018-01-11
* Mon Nov 27 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2017-11-30 (4468)
* Fri Oct 20 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2017-10-26 (4419)
* Wed Sep 27 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2017-10-02 (4379)
* Mon Aug 28 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2017-09-06 (4334)
* Tue Aug 01 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2017-08-07 (4304)
* Wed Jul 19 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for Patch 2017-07-24 (4289)
* Fri Jul 07 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for Patch 2017-07-17 (4264)
* Mon Jun 12 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for Patch 2017-06-19 (4220)
* Tue Jun 06 2017 Marcus Klein <marcus.klein@open-xchange.com>
Build for Patch 2017-06-08 (4187)
* Tue May 16 2017 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.8.0 release
* Thu May 04 2017 Marcus Klein <marcus.klein@open-xchange.com>
Second preview of 2.8.0 release
* Mon Apr 03 2017 Marcus Klein <marcus.klein@open-xchange.com>
First preview of 2.8.0 release
* Fri Dec 02 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.8.0 release
* Fri Nov 25 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 2.6.0 release
* Thu Nov 24 2016 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 2.6.0 release
* Tue Nov 15 2016 Marcus Klein <marcus.klein@open-xchange.com>
Third preview of 2.6.0 release
* Sat Oct 29 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second preview of 2.6.0 release
* Fri Oct 14 2016 Marcus Klein <marcus.klein@open-xchange.com>
First preview of 2.6.0 release
* Wed Oct 12 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.6.0 release
* Tue Jul 12 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.4.2 release
* Wed Jul 06 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.2 release
* Wed Jun 29 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second preview for 2.4.2 release
* Thu Jun 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.2 release
* Thu Jun 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.4.2
* Wed Mar 30 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.4.0 release
* Thu Mar 24 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.0 release
* Wed Mar 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
Fifth preview of 2.4.0 release
* Fri Mar 04 2016 Marcus Klein <marcus.klein@open-xchange.com>
Fourth preview of 2.4.0 release
* Sat Feb 20 2016 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 2.4.0 release
* Fri Feb 05 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.4.0 release
* Fri Feb 05 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.0 release
* Sun Dec 06 2015 Greg <greg@ubuntu>
Second candidate for 2.2.1 release
* Mon Nov 09 2015 Greg <greg@ubuntu>
First candidate for 2.2.1 release
* Mon Nov 09 2015 Greg <greg@ubuntu>
First release 2.2.1
* Fri Oct 23 2015 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.4.0 release
* Mon Oct 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate release for 2.2.0
* Sun Sep 27 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate release for 2.2.0
* Mon Sep 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate release 2.2.0
* Mon Sep 14 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-09-24 (2756)
* Mon Sep 14 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate release 2.2.0
* Mon Aug 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.2.0 release
* Mon Aug 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.2.0 release
* Mon Aug 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.2.0 release
* Wed Jul 29 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-07-27 (2626)
* Wed Jul 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-07-09 (2612)
* Tue Jun 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Final release candidate for Guard 2.0
* Mon Jun 29 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 2.0
* Sun Jun 28 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 2.0 release
* Sun Jun 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 2.0 release
* Sun Jun 14 2015 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.0 release
* Sun Jun 07 2015 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.0 release
* Tue Feb 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
Initial Release.
