Name:          open-xchange-guard-file-storage
BuildArch:     noarch
#!BuildIgnore: post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires: java7-devel
%else
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
BuildRequires: java-1_7_0-openjdk-devel
%else
BuildRequires: java-devel >= 1.7.0
%endif
%endif
BuildRequires: open-xchange-guard >= 2.8.0
Version:       2.8.0
%define        ox_release 22
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       OX Guard File Storage
Autoreqprov:   no
Requires:      open-xchange-guard >= 2.8.0
Provides:      open-xchange-guard-storage
Conflicts:     open-xchange-guard-s3-storage

%description
This package adds the bundles for file storage support to the OX Guard product.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build

%post
. /opt/open-xchange/lib/oxfunctions.sh

# prevent bash from expanding, see bug 13316
GLOBIGNORE='*'

if [ ${1:-0} -eq 1 ]; then # only during first install

    # SoftwareChange_Request 3105
    # Installing open-xchange-guard created a backup so we are able to take
    # over the previous config params to the new location.
    old_core_file_back=/opt/open-xchange/etc/guard.properties.move
    file_properties=/opt/open-xchange/etc/guard-file.properties
    key="com.openexchange.guard.storage.file.uploadDirectory"

    if [ -e $old_core_file_back ] && [ -e $file_properties ]; then
        #if property is uncommented
        if $(ox_exists_property ${key} ${old_core_file_back}); then
            value=$(ox_read_property ${key} ${old_core_file_back})
            #and property has a value
            if [ -n "${value}" ]; then
                ox_comment ${key} remove ${file_properties}
                ox_set_property ${key} "${value}" ${file_properties}
            fi
        fi
        # after open-xchange-guard and open-xchange-storage-* are installed we
        # can clean up as properties have been moved
        rm ${old_core_file_back}
    fi

elif [ ${1:-0} -eq 2 ]; then # only when updating
    : #remove noop when adding SCRs for updates
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
%config(noreplace) /opt/open-xchange/etc/guard-file.properties

%changelog
* Tue Jun 04 2019 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2019-06-11 (5265)
* Tue Dec 11 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-12-17 (5025)
* Thu Oct 18 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-10-22 (4929)
* Fri Oct 05 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-10-10 (4910)
* Tue Jun 26 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-07-02 (4804)
* Wed May 09 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-05-14 (4742)
* Tue Apr 17 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-04-23 (4648)
* Fri Mar 23 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-03-28 (4610)
* Mon Feb 12 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-02-05
* Mon Jan 08 2018 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2018-01-11
* Mon Nov 27 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2017-11-30 (4468)
* Fri Oct 20 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2017-10-26 (4419)
* Wed Sep 27 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2017-10-02 (4379)
* Mon Aug 28 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2017-09-06 (4334)
* Tue Aug 01 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2017-08-07 (4304)
* Wed Jul 19 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for Patch 2017-07-24 (4289)
* Fri Jul 07 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for Patch 2017-07-17 (4264)
* Mon Jun 12 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for Patch 2017-06-19 (4220)
* Tue Jun 06 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for Patch 2017-06-08 (4187)
* Tue May 16 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.8.0 release
* Thu May 04 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second preview of 2.8.0 release
* Mon Apr 03 2017 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First preview of 2.8.0 release
* Fri Dec 02 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
prepare for 2.8.0 release
* Fri Nov 25 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second release candidate for 2.6.0 release
* Thu Nov 24 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First release candidate for 2.6.0 release
* Tue Nov 15 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Third preview of 2.6.0 release
* Sat Oct 29 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second preview of 2.6.0 release
* Fri Oct 14 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First preview of 2.6.0 release
* Wed Oct 12 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
prepare for 2.6.0 release
* Tue Jul 12 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.2 release
* Wed Jul 06 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.2 release
* Wed Jun 29 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second preview for 2.4.2 release
* Thu Jun 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.2 release
* Thu Jun 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
prepare for 2.4.2
* Wed Mar 30 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.0 release
* Thu Mar 24 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.0 release
* Wed Mar 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Fifth preview of 2.4.0 release
* Fri Mar 04 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Fourth preview of 2.4.0 release
* Sat Feb 20 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Third candidate for 2.4.0 release
* Fri Feb 05 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.0 release
* Fri Feb 05 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.0 release
* Mon Nov 16 2015 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Initial release
