/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets;

import javax.servlet.ServletException;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.servlets.callback.CallbackServlet;
import com.openexchange.guard.servlets.demo.DemoServlet;
import com.openexchange.guard.servlets.guest.GuestServlet;
import com.openexchange.guard.servlets.guestreader.GuestReaderServlet;
import com.openexchange.guard.servlets.keymanagement.KeymanagementServlet;
import com.openexchange.guard.servlets.keyretrieval.KeyRetrievalServlet;
import com.openexchange.guard.servlets.login.LoginServlet;
import com.openexchange.guard.servlets.mail.MailServlet;
import com.openexchange.guard.servlets.mailvelope.MailvelopeServlet;
import com.openexchange.guard.servlets.pgp.PGPServlet;
import com.openexchange.guard.servlets.pgpcore.PGPCoreServlet;
import com.openexchange.guard.servlets.pgpmail.PGPMailServlet;
import com.openexchange.guard.servlets.ping.PingServlet;
import com.openexchange.guard.servlets.settings.SettingsServlet;
import com.openexchange.guard.servlets.supportApi.SupportServlet;

/**
 * Handles registration and de-registration of OX Guard servlets
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class GuardServlets {

    private static final Logger LOG = LoggerFactory.getLogger(GuardServlets.class);

    private static final String GUARD_LOGIN_SERVLET_PATH = "/oxguard/login";
    private static final String GUARD_PING_SERVLET_PATH = "/oxguard/ping";
    private static final String GUARD_KEY_MANAGEMENT_SERVLET_PATH = "/oxguard/keys";
    private static final String GUARD_PGP_CORE_SERVLET_PATH = "/oxguard/pgpcore";
    private static final String GUARD_PGP_SERVLET_PATH = "/oxguard/pgp";
    private static final String GUARD_PGPMAIL_SERVLET_PATH = "/oxguard/pgpmail";;
    private static final String GUARD_MAIL_SERVLET_PATH = "/oxguard/mail";;
    private static final String GUARD_SETTINGS_SERVLET_PATH = "/oxguard/settings";
    private static final String GUARD_GUEST_SERVLET_PATH = "/oxguard/guest";
    private static final String GUARD_KEY_RETRIEVAL_SERVLET_PATH = "/oxguard/retrieve";
    private static final String GUARD_DEMO_SERVLET_PATH = "/oxguard/demo";
    private static final String GUARD_CALLBACK_SERVLET_PATH = "/guardadmin";
    private static final String GUARD_SUPPORT_SERVLET_PATH = "/guardsupport";
    private static final String GUARD_MAILVELOPE_SERVLET_PATH = "/oxguard/mailvelope";
    private static final String GUARD_GUEST_READER_PATH = "/oxguard/reader";

    /**
     * Registers OX Guard servlets to the given service
     *
     * @param httpService The service where to register the servlets
     * @throws NamespaceException
     * @throws ServletException
     * @throws OXException
     */
    public static void registerServlets(HttpService httpService) throws ServletException, NamespaceException, OXException {
        if (httpService == null) {
            LOG.error("Unable to register guard servlets. HttpService is null!");
            return;
        }
        httpService.registerServlet(GUARD_PING_SERVLET_PATH, new PingServlet(), null, null);
        httpService.registerServlet(GUARD_KEY_MANAGEMENT_SERVLET_PATH, new KeymanagementServlet(), null, null);
        httpService.registerServlet(GUARD_PGP_CORE_SERVLET_PATH, new PGPCoreServlet(), null, null);
        httpService.registerServlet(GUARD_PGP_SERVLET_PATH, new PGPServlet(), null, null);
        httpService.registerServlet(GUARD_PGPMAIL_SERVLET_PATH, new PGPMailServlet(), null, null);
        httpService.registerServlet(GUARD_MAIL_SERVLET_PATH, new MailServlet(), null, null);
        httpService.registerServlet(GUARD_LOGIN_SERVLET_PATH, new LoginServlet(), null, null);
        httpService.registerServlet(GUARD_GUEST_SERVLET_PATH, new GuestServlet(), null, null);
        httpService.registerServlet(GUARD_KEY_RETRIEVAL_SERVLET_PATH, new KeyRetrievalServlet(), null, null);
        httpService.registerServlet(GUARD_SETTINGS_SERVLET_PATH, new SettingsServlet(), null, null);
        httpService.registerServlet(GUARD_SUPPORT_SERVLET_PATH, new SupportServlet(), null, null);
        httpService.registerServlet(GUARD_DEMO_SERVLET_PATH, new DemoServlet(), null, null);
        httpService.registerServlet(GUARD_CALLBACK_SERVLET_PATH, new CallbackServlet(), null, null);
        httpService.registerServlet(GUARD_MAILVELOPE_SERVLET_PATH, new MailvelopeServlet(), null, null);
        httpService.registerServlet(GUARD_GUEST_READER_PATH, new GuestReaderServlet(), null, null);
    }

    /**
     * Unregisters OX Guard servlets from the given service
     *
     * @param httpService The service to unregister the servlets from
     */
    public static void unregisterServlets(HttpService httpService) {
        if (httpService == null) {
            LOG.debug("Unable to unregister guard servlets. HttpService is null!");
            return;
        }
        httpService.unregister(GUARD_PING_SERVLET_PATH);
        httpService.unregister(GUARD_PGP_CORE_SERVLET_PATH);
        httpService.unregister(GUARD_PGP_SERVLET_PATH);
        httpService.unregister(GUARD_PGPMAIL_SERVLET_PATH);
        httpService.unregister(GUARD_MAIL_SERVLET_PATH);
        httpService.unregister(GUARD_LOGIN_SERVLET_PATH);
        httpService.unregister(GUARD_GUEST_SERVLET_PATH);
        httpService.unregister(GUARD_KEY_RETRIEVAL_SERVLET_PATH);
        httpService.unregister(GUARD_SETTINGS_SERVLET_PATH);
        httpService.unregister(GUARD_SUPPORT_SERVLET_PATH);
        httpService.unregister(GUARD_DEMO_SERVLET_PATH);
        httpService.unregister(GUARD_CALLBACK_SERVLET_PATH);
        httpService.unregister(GUARD_MAILVELOPE_SERVLET_PATH);
        httpService.unregister(GUARD_GUEST_READER_PATH);
    }
}
