/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgp;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.openexchange.guard.common.java.Strings;
import com.openexchange.guard.keymanagement.commons.trust.KeySource;

public class PGPResult {

    private byte[] decoded;

    private boolean signature;

    private boolean verified;

    private boolean missingPublicKey;

    private String error = null;

    private String content = null;

    private KeySource source = null;

    public PGPResult() {
        this(false, false, null, false, null, null, null);
    }

    public PGPResult(boolean signature, boolean verified, byte[] decoded, boolean missingPublicKey, String lContent, String lError, KeySource source) {
        this.signature = signature;
        this.verified = verified;
        this.decoded = decoded;
        this.missingPublicKey = missingPublicKey;
        this.content = lContent;
        this.error = lError;
        this.source = source;
    }

    public String getJsonString() {
        JsonObject result = new JsonObject();
        result.add("signature", new JsonPrimitive(signature));
        result.add("verified", new JsonPrimitive(verified));
        result.add("missingPublicKey", new JsonPrimitive(missingPublicKey));
        if (Strings.isNotEmpty(this.error)) {
            result.addProperty("error", error);
        }
        if (Strings.isNotEmpty(this.content)) {
            result.add("content", new JsonPrimitive(this.content));
        }
        if (source != null) {
        	result.add("source", new JsonPrimitive(source.getName()));
        }
        return result.toString();
    }

    public byte[] getDecoded() {
        return decoded;
    }

    public void setDecoded(byte[] decoded) {
        this.decoded = decoded;
    }

    public boolean isSignature() {
        return signature;
    }

    public void setSignature(boolean signature) {
        this.signature = signature;
    }

    public boolean isVerified() {
        return verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean isMissingPublicKey() {
        return missingPublicKey;
    }

    public void setMissingPublicKey(boolean missingPublicKey) {
        this.missingPublicKey = missingPublicKey;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return content;
    }

    public void setSource(KeySource source) {
    	this.source = source;
    }

    public KeySource getSource () {
    	return source;
    }
}
