/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.mail;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.inputvalidation.UUIDValidator;
import com.openexchange.guard.internal.UserData;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.oxapi.OxCookie;
import com.openexchange.guard.pgp.PGPResult;
import com.openexchange.guard.pgp.PGPStringProcessor;
import com.openexchange.guard.storage.Storage;

public class UploadGuest {

    private static Logger LOG = LoggerFactory.getLogger(UploadGuest.class);

    public void incomingEmailForm(HttpServletRequest request, HttpServletResponse response, OxCookie cookie) throws Exception {
        String auth = ServletUtils.getStringParameter(request, "auth", true);
        cookie.setJSESSIONID(cookie.getOxReaderID());
        UserData user = new UserData(auth, cookie);
        if (user.getUserid() < 0) {
            ServletUtils.sendNotAcceptable(response, "Bad auth");
            return;
        }
        String ascData = "";
        FileItemFactory fif = new DiskFileItemFactory();
        ServletFileUpload sfu = new ServletFileUpload(fif);
        List<FileItem> files = sfu.parseRequest(request);
        Iterator<FileItem> iterator = files.iterator(); // Iterate through attachments
        boolean pgp = false;
        while (iterator.hasNext()) {
            FileItem fi = iterator.next();
            String name = fi.getName(); // Otherwise, assume it is an attachment
            if (name != null) {// Make sure the name of the file exists, may just be blank field
                if (name.endsWith(".asc")) {
                    pgp = true;
                }
                else {
                    ServletUtils.sendNotAcceptable(response, "Not valid Guard files");
                    return;
                }
                if (name.trim() != "") {
                    if (name.lastIndexOf("\\") > -1) {
                        name = name.substring(name.lastIndexOf("\\"));
                    }
                    if (name.lastIndexOf("/") > -1) {
                        name = name.substring(name.lastIndexOf("/"));
                    }
                    InputStream input = fi.getInputStream();
                    if (pgp) {
                        StringWriter writer = new StringWriter();
                        IOUtils.copy(input, writer);
                        ascData = writer.toString();
                        writer.close();
                    }
                    input.close();
                }
            }
        }

        Storage storage = Services.getService(Storage.class);

        if (pgp) {
            String itemId = new UUIDValidator("pgp-").assertInput(ServletUtils.getStringParameter(request, "itemid", true),"itemid");
            // Check decodable
            PGPStringProcessor ps = new PGPStringProcessor();
            try {
                PGPResult rs = ps.DecryptString(user.getEncr_password(), ascData, user.getUserid(), user.getCid());
                if (rs.getDecoded() == null) {
                    ServletUtils.sendNotAcceptable(response, "not decodable");
                    return;
                }
            } catch (Exception e) {
                LOG.error("Fail with user uploading Guest reader old email", e);
                ServletUtils.sendNotAcceptable(response, "not decodable");
                return;
            }
            // OK decodable, now let's store it
            if (!storage.saveEncrObj(user.getUserid(), user.getCid(), itemId, ascData.getBytes("UTF-8"))) {
                ServletUtils.sendNotAcceptable(response, "Storage failure");
                return;
            }
        }
        else {
            ServletUtils.sendNotAcceptable(response, "No data");
            return;
        }
        ServletUtils.sendHtmlOK(response, "OK");
    }
}
