/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.storage.impl.osgi;

import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.GuardDatabaseService;
import com.openexchange.guard.database.GuardShardingService;
import com.openexchange.guard.keymanagement.storage.DeletedKeysStorage;
import com.openexchange.guard.keymanagement.storage.KeyCacheStorage;
import com.openexchange.guard.keymanagement.storage.KeyTableStorage;
import com.openexchange.guard.keymanagement.storage.OGPGPKeysStorage;
import com.openexchange.guard.keymanagement.storage.PGPKeysStorage;
import com.openexchange.guard.keymanagement.storage.RemoteKeyCacheStorage;
import com.openexchange.guard.keymanagement.storage.impl.deletedkeys.DeletedKeysStorageImpl;
import com.openexchange.guard.keymanagement.storage.impl.keycache.KeyCacheStorageImpl;
import com.openexchange.guard.keymanagement.storage.impl.keytable.KeyTableStorageImpl;
import com.openexchange.guard.keymanagement.storage.impl.pgpkeys.OGPGPKeysStorageImpl;
import com.openexchange.guard.keymanagement.storage.impl.pgpkeys.PGPKeysStorageImpl;
import com.openexchange.guard.keymanagement.storage.impl.remotekeys.RemoteKeyCacheStorageImpl;
import com.openexchange.guard.ratifier.GuardRatifierService;
import com.openexchange.osgi.HousekeepingActivator;

/**
 * {@link KeyManagementStorageImplActivator}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.6.0
 */
public class KeyManagementStorageImplActivator extends HousekeepingActivator {

    /*
     * (non-Javadoc)
     *
     * @see com.openexchange.osgi.DeferredActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] {GuardDatabaseService.class, GuardShardingService.class, GuardRatifierService.class };
    }

    /*
     * (non-Javadoc)
     *
     * @see com.openexchange.osgi.DeferredActivator#startBundle()
     */
    @Override
    protected void startBundle() throws Exception {

        org.slf4j.LoggerFactory.getLogger(KeyManagementStorageImplActivator.class).info("Starting bundle: {}", context.getBundle().getSymbolicName());
        Services.setServiceLookup(this);

        // Register storages
        registerService(KeyCacheStorage.class, new KeyCacheStorageImpl());
        registerService(KeyTableStorage.class, new KeyTableStorageImpl());
        registerService(OGPGPKeysStorage.class, new OGPGPKeysStorageImpl());
        registerService(PGPKeysStorage.class, new PGPKeysStorageImpl());
        registerService(DeletedKeysStorage.class, new DeletedKeysStorageImpl());
        registerService(RemoteKeyCacheStorage.class, new RemoteKeyCacheStorageImpl());

        // Track storages
        trackService(KeyCacheStorage.class);
        trackService(KeyTableStorage.class);
        trackService(OGPGPKeysStorage.class);
        trackService(PGPKeysStorage.class);
        trackService(DeletedKeysStorage.class);
        trackService(RemoteKeyCacheStorage.class);

    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.DeferredActivator#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        final Logger logger = LoggerFactory.getLogger(KeyManagementStorageImplActivator.class);
        logger.info("Stopping bundle {}", context.getBundle().getSymbolicName());

        unregisterService(KeyCacheStorage.class);
        unregisterService(KeyTableStorage.class);
        unregisterService(OGPGPKeysStorage.class);
        unregisterService(PGPKeysStorage.class);
        unregisterService(DeletedKeysStorage.class);
        unregisterService(RemoteKeyCacheStorage.class);

        logger.info("Key management storages unregistered.");
        Services.setServiceLookup(null);
        super.stopBundle();
    }

}
