/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.storage.impl.keytable;

class KeyTableSql {

    static final String OG_KEY_TABLE = "og_KeyTable";
    static final String SELECT_GUARD_DAEMON_KEY_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = -1 AND cid = 0";
    static final String SELECT_FOR_USER_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = ? AND cid = ? ORDER BY version DESC";
    static final String SELECT_FOR_USER_BY_KEYID_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = ? AND cid = ? AND keyid = ?";
    static final String SELECT_FOR_CONTEXT_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE cid = ?";
    static final String SELECT_FOR_EMAIL_IN_CONTEXT_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE email = ?";
    static final String SELECT_CURRENT_FOR_USER_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE id = ? AND cid = ? AND current=1";
    static final String SELECT_CURRENT_FOR_USER_EMAIL_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE email = ? AND current = 1";;
    static final String SELECT_HIGHEST_VERSION_KEY_STMT = "SELECT PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Salt, misc, settings, email, lastMod, question, answer, cid, id, keyid, version, current, lang, Recovery FROM og_KeyTable WHERE cid = ? AND id = ? AND version=(SELECT MAX(version) from og_KeyTable where cid = ? and id = ?)";
    static final String INSERT_STMT = "INSERT INTO og_KeyTable (id, cid, PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Recovery, Salt, email, lastMod, lang, keyid, version, question, answer, settings, current) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, ?, ?, ?, ?, ?, ?,?)";
    static final String INSERT_AND_SET_LASTMOD_STMT = "INSERT INTO og_KeyTable (id, cid, PGPSecret, PGPPublic, RSAPrivate, RSAPublic, Recovery, Salt, email, lastMod, lang, keyid, version, question, answer, settings, current) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?, ?, ?, ?, ?,?)";
    static final String DELETE_KEY_STMT = "DELETE FROM og_KeyTable WHERE cid = ? AND id = ? AND keyid = ?";
    static final String DELETE_FOR_USER_STMT = "DELETE FROM og_KeyTable WHERE id = ? AND cid = ?";
    static final String DELETE_FOR_CONTEXT_STMT = "DELETE FROM og_KeyTable WHERE cid = ?";
    static final String DELETE_RECOVERY_FROM_KEY_STMT = "UPDATE og_KeyTable SET Recovery = '' WHERE id = ? and cid = ?";
    static final String UPDATE_PGP_PUBLIC_STMT = "UPDATE og_KeyTable SET PGPPublic = ? WHERE keyid = ?";
    static final String UPDATE_PGP_PUBLIC_AND_PRIVATE_STMT = "UPDATE og_KeyTable Set PGPSecret = ?, PGPPublic = ? WHERE id = ? AND cid = ? AND keyid = ?";
    static final String UPDATE_QUESTION_STMT = "UPDATE og_KeyTable SET question = ?, answer = ?" + " WHERE id = ? AND cid = ?";
    static final String UPDATE_PASSWORDS_AND_LASTMOD_STMT = "UPDATE og_KeyTable Set PGPSecret = ?, RSAPrivate = ?, Recovery = ?, lastMod = NOW() WHERE id = ? AND cid = ? AND keyid = ?;";
    static final String UPDATE_PASSWORDS_STMT = "UPDATE og_KeyTable Set PGPSecret = ?, RSAPrivate = ?, Recovery = ?, lastMod = NULL WHERE id = ? AND cid = ? AND keyid = ?;";
    static final String UPDATE_DUPLICATED_STMT = "UPDATE og_KeyTable SET RSAPrivate = ?, PGPSecret = ?, PGPPublic = ?, Recovery = ?, Salt = ? WHERE id = ? AND cid = ? and keyid = ?";
    static final String UPDATE_PIN_STMT = "UPDATE og_KeyTable Set question = 'PIN', answer = ? WHERE id = ? AND cid = ?;";
    static final String UPDATE_VERSION_STMT = "UPDATE og_KeyTable SET version = ? WHERE cid = ? AND id = ? AND version = ?";
    static final String UPDATE_SETTINGS_FOR_USER_STMT = "UPDATE og_KeyTable SET og_KeyTable.settings = ? WHERE og_KeyTable.id = ? and cid = ?";
    static final String SET_CURRENT_STMT = "UPDATE og_KeyTable SET current = 1 WHERE id = ? and cid = ? and keyid = ?";
    static final String UNSET_CURRENT_FOR_USER_STMT = "UPDATE og_KeyTable SET current = 0 WHERE id = ? and cid = ?";
    static final String EXISTS_STMT = "SELECT id FROM og_KeyTable LIMIT 1";
    static final String ALTER_AUTOINCREMENT_STMT = "ALTER TABLE `og_KeyTable` AUTO_INCREMENT=?";
}
