/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.commons;

import org.bouncycastle.openpgp.PGPPublicKeyRing;

/**
 * {@link OGPGPKeyRing}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.6.0
 */
public class OGPGPKeyRing {

    private PGPPublicKeyRing keyRing;
    private int shareLevel;
    private boolean inline;
    private final String ids;

    /**
     * Initializes a new {@link OGPGPKeyRing}.
     *
     * @param publicKeyRing The PGP key ring
     * @param isInline Whether the key is marked as "inline" or not
     * @param shareLevel The share level of the key
     */
    public OGPGPKeyRing(String ids, PGPPublicKeyRing publicKeyRing, boolean isInline, int shareLevel) {
        this.ids = ids;
        this.keyRing = publicKeyRing;
        this.inline = isInline;
        this.shareLevel = shareLevel;
    }

    /**
     * Gets the ids
     *
     * @return The ids
     */
    public String getIds() {
        return ids;
    }

    /**
     * Gets the {@link PGPPublicKeyRing}
     *
     * @return The {@link PGPPublicKeyRing}
     */
    public PGPPublicKeyRing getKeyRing() {
        return keyRing;
    }

    /**
     * Sets the {@link PGPPublicKeyRing}
     *
     * @param keyRing The {@link PGPPublicKeyRing} to set
     */
    public void setKeyRing(PGPPublicKeyRing keyRing) {
        this.keyRing = keyRing;
    }

    /**
     * Gets the share level
     *
     * @return The share level
     */
    public int getShareLevel() {
        return shareLevel;
    }

    /**
     * Sets the share level
     *
     * @param shareLevel The share level to set
     */
    public void setShareLevel(int shareLevel) {
        this.shareLevel = shareLevel;
    }

    /**
     * Gets whether the key is marked to be used as "inline" or not
     *
     * @return Tue, if the key is marked to be used as "inline", false otherwise.
     */
    public boolean isInline() {
        return inline;
    }

    /**
     * Sets whether the key is marked as inline or not.
     *
     * @param inline True in order to marke the key as inline, False to mark it for PGP-Mime.
     */
    public void setInline(boolean inline) {
        this.inline = inline;
    }
}
