package com.openexchange.guard.antiabuse.weakforced;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.antiabuse.AntiAbuseService;
import com.openexchange.antiabuse.ReportValue;
import com.openexchange.antiabuse.Status;
import com.openexchange.exception.OXException;
import com.openexchange.guard.antiabuse.osgi.Services;

public class WeakforcedImpl {


	private static final Logger LOG = LoggerFactory.getLogger(WeakforcedImpl.class);

	private static Map<String, String> properties;

	private AntiAbuseService getWeakForced () {
		AntiAbuseService wf;
		properties = new HashMap<String, String> ();
		properties.put("app", "oxguard");
		try {
			wf = Services.getService(AntiAbuseService.class);
		} catch (OXException e) {
			return null;
		}
		return (wf);
	}


	/**
	 * Perform allow call to weakforced
	 * If service unavailable, return OK for login
	 * @param login
	 * @param password
	 * @param remoteAddress
	 * @return
	 */
	private Status allow (String login, String password, String remoteAddress) {
		AntiAbuseService wf = getWeakForced();
		if (wf != null) {
			try {
				Status status = wf.allow(login, password, remoteAddress, properties);
				return (status);
			} catch (OXException e) {
				LOG.error("Problem checking weakforced ", e);
			}
		}
		return null;
	}

	/**
	 * Send weakforced report
	 * @param reportValue
	 * @param login
	 * @param password
	 * @param remoteAddress
	 */
	private void report (ReportValue reportValue, String login, String password, String remoteAddress) {
		AntiAbuseService wf = getWeakForced();
		if (wf != null) {
			try {
				wf.report(reportValue, login, password, remoteAddress);
			} catch (OXException e) {
				LOG.error("Problem reporting weakforced ", e);
			}
		}
		return;
	}

	/**
	 * Check if login is to be allowed
	 * @param login
	 * @param password
	 * @param remoteAddress
	 * @return
	 */
	public boolean isAllowed (String login, String password, String remoteAddress) {
		Status status = allow (login, password, remoteAddress);
		if (status == null) return true;
		if (!status.isOk()) {
			LOG.error(String.format("Login blocked for %s at %s by weakforced", login ,remoteAddress));
		}
		return (status.isOk());
	}

	/**
	 * Check if login is blocked
	 * @param login
	 * @param password
	 * @param remoteAddress
	 * @return
	 */
	public boolean isBlocked (String login, String password, String remoteAddress) {
		Status status = allow (login, password, remoteAddress);
		if (status == null) return false;
		if (status.isBlocked()) {
			LOG.error(String.format("Login blocked for %s at %s by weakforced", login ,remoteAddress));
		}
		return (status.isBlocked());
	}

	/**
	 * Report failed login to weakforced
	 * @param login
	 * @param password
	 * @param remoteAddress
	 */
	public void reportBad (String login, String password, String remoteAddress) {
		report (ReportValue.FAILURE, login, password, remoteAddress);
	}

	/**
	 * Report successful login
	 * @param login
	 * @param password
	 * @param remoteAddress
	 */
	public void reportOK (String login, String password, String remoteAddress) {
		report (ReportValue.SUCCESS, login, password, remoteAddress);
	}
}
