package com.openexchange.guard.antiabuse.internal;

import com.openexchange.exception.OXException;
import com.openexchange.guard.antiabuse.GuardAntiAbuseService;
import com.openexchange.guard.antiabuse.bad.Bad;
import com.openexchange.guard.antiabuse.bad.GuardBadStorage;
import com.openexchange.guard.antiabuse.bad.GuardBadStorageImpl;
import com.openexchange.guard.antiabuse.weakforced.WeakforcedImpl;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.configuration.GuardProperty;

public class GuardAntiAbuseImpl implements GuardAntiAbuseService {

	GuardBadStorage bad;
	WeakforcedImpl wf;
	GuardConfigurationService config;

	public GuardAntiAbuseImpl (GuardConfigurationService config) {
		bad = new GuardBadStorageImpl();
		wf = new WeakforcedImpl();
		this.config = config;
	}

	@Override
	public Bad getBad(String id) throws OXException {
		return bad.getBad(id);
	}

	@Override
	public void addBad(String id) throws OXException {
		bad.addBad(id);
	}

	@Override
	public void removeBad(String id) throws OXException {
		bad.removeBad(id);
	}

	@Override
	public boolean isBad(String id, int threshold) throws OXException {
		return bad.isBad(id, threshold);
	}

	@Override
	public boolean isBad(String id) throws OXException {
		return bad.isBad(id);
	}

	@Override
	public boolean allowLogin(String username, String password, String ip) throws OXException {
		if (bad.isBad(username, config.getIntProperty(GuardProperty.badPasswordCount))) return false;
		return wf.isAllowed(username, password, ip);
	}

	@Override
	public boolean allowLogin(int userid, int cid, String password, String ip) throws OXException {
		String username = userid + "-" + cid;
		return allowLogin(username, password, ip);
	}

	@Override
	public boolean blockLogin(int userid, int cid, String password, String ip) throws OXException {
		return (!allowLogin(userid, cid, password, ip));
	}

	@Override
	public boolean blockLogin(String username, String password, String ip) throws OXException {
		return (!allowLogin(username, password, ip));
	}

	@Override
	public void reportLogin(boolean success, String username, String password, String ip) throws OXException {
		if (success) {
			removeBad(username);  // Remove from our local lockout
			wf.reportOK(username, password, ip);  // Report to weakforced
		} else {
			addBad(username);  // Add to our local lockout
			wf.reportBad(username, password, ip);  // Report to weakforced
		}
	}

	@Override
	public void reportLogin(boolean success, int userid, int cid, String password, String ip) throws OXException {
		String username = userid + "-" + cid;
		reportLogin (success, username, password, ip);
	}




}
