/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.SingleNameBase;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class SingleNameBaseTest
extends TestCase {
    private void assertEquals(byte[] exp, byte[] act) {
        SingleNameBaseTest.assertTrue((boolean)Arrays.equals(exp, act));
    }

    public void test_ctor() throws TextParseException {
        TestClass tc = new TestClass();
        SingleNameBaseTest.assertNull((Object)tc.getSingleName());
        Name n = Name.fromString("my.name.");
        Name sn = Name.fromString("my.single.name.");
        tc = new TestClass(n, 1, 1, 100L);
        SingleNameBaseTest.assertSame((Object)n, (Object)tc.getName());
        SingleNameBaseTest.assertEquals((int)1, (int)tc.getType());
        SingleNameBaseTest.assertEquals((int)1, (int)tc.getDClass());
        SingleNameBaseTest.assertEquals((long)100L, (long)tc.getTTL());
        tc = new TestClass(n, 1, 1, 100L, sn, "The Description");
        SingleNameBaseTest.assertSame((Object)n, (Object)tc.getName());
        SingleNameBaseTest.assertEquals((int)1, (int)tc.getType());
        SingleNameBaseTest.assertEquals((int)1, (int)tc.getDClass());
        SingleNameBaseTest.assertEquals((long)100L, (long)tc.getTTL());
        SingleNameBaseTest.assertSame((Object)sn, (Object)tc.getSingleName());
    }

    public void test_rrFromWire() throws IOException {
        byte[] raw = new byte[]{2, 109, 121, 6, 115, 105, 110, 103, 108, 101, 4, 110, 97, 109, 101, 0};
        DNSInput in = new DNSInput(raw);
        TestClass tc = new TestClass();
        tc.rrFromWire(in);
        Name exp = Name.fromString("my.single.name.");
        SingleNameBaseTest.assertEquals((Object)exp, (Object)tc.getSingleName());
    }

    public void test_rdataFromString() throws IOException {
        Name exp = Name.fromString("my.single.name.");
        Tokenizer t = new Tokenizer("my.single.name.");
        TestClass tc = new TestClass();
        tc.rdataFromString(t, null);
        SingleNameBaseTest.assertEquals((Object)exp, (Object)tc.getSingleName());
        t = new Tokenizer("my.relative.name");
        tc = new TestClass();
        try {
            tc.rdataFromString(t, null);
            SingleNameBaseTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_rrToString() throws IOException, TextParseException {
        Name exp = Name.fromString("my.single.name.");
        Tokenizer t = new Tokenizer("my.single.name.");
        TestClass tc = new TestClass();
        tc.rdataFromString(t, null);
        SingleNameBaseTest.assertEquals((Object)exp, (Object)tc.getSingleName());
        String out = tc.rrToString();
        SingleNameBaseTest.assertEquals((String)out, (String)exp.toString());
    }

    public void test_rrToWire() throws IOException, TextParseException {
        Name n = Name.fromString("my.name.");
        Name sn = Name.fromString("My.Single.Name.");
        TestClass tc = new TestClass(n, 1, 1, 100L, sn, "The Description");
        byte[] exp = new byte[]{2, 77, 121, 6, 83, 105, 110, 103, 108, 101, 4, 78, 97, 109, 101, 0};
        DNSOutput dout = new DNSOutput();
        tc.rrToWire(dout, null, false);
        byte[] out = dout.toByteArray();
        this.assertEquals(exp, out);
        tc = new TestClass(n, 1, 1, 100L, sn, "The Description");
        exp = new byte[]{2, 109, 121, 6, 115, 105, 110, 103, 108, 101, 4, 110, 97, 109, 101, 0};
        dout = new DNSOutput();
        tc.rrToWire(dout, null, true);
        out = dout.toByteArray();
        this.assertEquals(exp, out);
    }

    private static class TestClass
    extends SingleNameBase {
        public TestClass() {
        }

        public TestClass(Name name, int type, int dclass, long ttl) {
            super(name, type, dclass, ttl);
        }

        public TestClass(Name name, int type, int dclass, long ttl, Name singleName, String desc) {
            super(name, type, dclass, ttl, singleName, desc);
        }

        public Name getSingleName() {
            return super.getSingleName();
        }

        public Record getObject() {
            return null;
        }
    }
}

