Name:          open-xchange-guard-s3-storage
BuildArch:     noarch
#!BuildIgnore: post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires: java7-devel
%else
BuildRequires: java-devel >= 1.7.0
%endif
BuildRequires: open-xchange-guard >= 2.6.0
BuildRequires: open-xchange-filestore-s3 >= 7.8.1
Version:       2.6.0
%define        ox_release 5
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       OX Guard File Storage
Autoreqprov:   no
Requires:      open-xchange-filestore-s3 >= 7.8.1
Requires:      open-xchange-guard >= 2.6.0
Provides:      open-xchange-guard-storage
Conflicts:     open-xchange-guard-file-storage

%description
This package adds the bundles for S3 storage support to the OX Guard product.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build

%post
. /opt/open-xchange/lib/oxfunctions.sh

# prevent bash from expanding, see bug 13316
GLOBIGNORE='*'

if [ ${1:-0} -eq 1 ]; then # only during first install

    # SoftwareChange_Request 3105
    # Installing open-xchange-guard created a backup so we are able to take
    # over the previous config params to the new location.
    old_core_file_back=/opt/open-xchange/etc/guard.properties.move
    s3_properties=/opt/open-xchange/etc/guard-s3.properties
    key_prefix="com.openexchange.guard.storage.s3."
    old_keys=( endpoint bucketName region accessKey secretKey )
    new_keys=( endPoint bucketName region accessKey secretKey )

    if [ -e ${old_core_file_back} ] && [ -e ${s3_properties} ]; then
        last_index=$(( ${#old_keys[@]}-1 ))
        for index in $(seq 0 ${last_index}); do
            old_name=${key_prefix}${old_keys[$index]}
            new_name=${key_prefix}${new_keys[$index]}
            #if property is uncommented
            if $(ox_exists_property ${old_name} ${old_core_file_back}); then
                value=$(ox_read_property ${old_name} ${old_core_file_back})
                #and property has a value
                if [ -n "${value}" ]; then
                    ox_comment ${new_name} remove ${s3_properties}
                    ox_set_property ${new_name} "${value}" ${s3_properties}
                fi
            fi
        done
        # after open-xchange-guard and open-xchange-storage-* are installed we
        # can clean up as properties have been moved
        rm ${old_core_file_back}
    fi

elif [ ${1:-0} -eq 2 ]; then # only when updating
    : #remove noop when adding SCRs for updates
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
%config(noreplace) /opt/open-xchange/etc/guard-s3.properties

%changelog
* Fri Nov 25 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second release candidate for 2.6.0 release
* Thu Nov 24 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First release candidate for 2.6.0 release
* Tue Nov 15 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Third preview of 2.6.0 release
* Sat Oct 29 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second preview of 2.6.0 release
* Fri Oct 14 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First preview of 2.6.0 release
* Wed Oct 12 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
prepare for 2.6.0 release
* Tue Jul 12 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.2 release
* Wed Jul 06 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.2 release
* Wed Jun 29 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second preview for 2.4.2 release
* Thu Jun 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.2 release
* Thu Jun 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
prepare for 2.4.2
* Wed Mar 30 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.0 release
* Thu Mar 24 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.0 release
* Wed Mar 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Fifth preview of 2.4.0 release
* Fri Mar 04 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Fourth preview of 2.4.0 release
* Sat Feb 20 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Third candidate for 2.4.0 release
* Fri Feb 05 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.0 release
* Fri Feb 05 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.0 release
