Name:             open-xchange-guard
BuildArch:        noarch
#!BuildIgnore:    post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires:    ant
%else
BuildRequires:    ant-nodeps
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires:    java7-devel
%else
BuildRequires:    java-devel >= 1.7.0
%endif
BuildRequires:    open-xchange-core
Version:          2.4.2
%define           ox_release 6
Release:          %{ox_release}_<CI_CNT>.<B_CNT>
Group:            Applications/Productivity
License:          GPL-2.0
BuildRoot:        %{_tmppath}/%{name}-%{version}-build
URL:              http://www.open-xchange.com/
Source:           %{name}_%{version}.orig.tar.bz2
Summary:          Open-Xchange Guard micro service
Requires:         open-xchange >= 7.8.1
Requires:         open-xchange-core >= 7.8.1

%description
Guard - the Open-Xchange security solution. This package contains the Guard backend component.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/spool/open-xchange/guard/uploads
mkdir -p %{buildroot}%{_sbindir}

%pre
. /opt/open-xchange/lib/oxfunctions.sh
if [ ${1:-0} -eq 2 ]; then
    # only when updating

    # SoftwareChange_Request-2933
    %if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
        systemctl --no-reload disable open-xchange-guard.service > /dev/null 2>&1 || :
        systemctl stop open-xchange-guard.service > /dev/null 2>&1 || :
    %else
        /sbin/service open-xchange-guard stop >/dev/null 2>&1 || :
        /sbin/chkconfig --del open-xchange-guard || :
    %endif
fi

%post
. /opt/open-xchange/lib/oxfunctions.sh
if [ ${1:-0} -eq 2 ]; then
    # only when updating

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # SoftwareChange_Request 2900, 2902, 2975, 3105, 3139
    # additionally backup old guard.properties file
    old_core_file=/opt/open-xchange/guard/etc/guard.properties
    old_core_file_back=/opt/open-xchange/etc/guard.properties.move
    new_core_file=/opt/open-xchange/etc/guard-core.properties
    key_prefix="com.openexchange.guard."
    core_names_22=( aesKeyLength backend_SSL badMinuteLock badPasswordCount cacheDays connectiontimeout cronHour databasePassword databaseUsername dbSchemaBaseName defaultLanguage exposedKeyDurationInHours externalEmailURL externalReaderPath guestSMTPPassword guestSMTPPort guestSMTPServer guestSMTPUsername keycachecheckinterval keyValidDays mailIdDomain mailresolverurl maxhttpconnections maxtotalconnections minpasswordlength newpasslength noDeletePrivate noDeleteRecovery noRecovery oxbackendidletime oxbackendpath OXBackendPort oxguardDatabaseHostname oxguardDatabaseRead oxguardShardDatabase oxguardShardRead passwordFromAddress passwordFromName pgpCacheDays publicKeyWhitelist publicPGPDirectory restApiHostname restApiPassword restApiUsername rsacache rsacachecount rsacertainty rsaKeyLength shardsize supportapipassword supportapiusername usestarttls productName )

    core_names_24=( aesKeyLength backendSSL badMinuteLock badPasswordCount cacheDays connectionTimeout cronHour databasePassword databaseUsername dbSchemaBaseName defaultLanguage exposedKeyDurationInHours externalEmailURL externalReaderPath guestSMTPPassword guestSMTPPort guestSMTPServer guestSMTPUsername keyCacheCheckInterval keyValidDays mailIdDomain mailResolverUrl maxHttpConnections maxTotalConnections minPasswordLength newPassLength noDeletePrivate noDeleteRecovery noRecovery oxBackendIdleTime oxBackendPath oxBackendPort oxGuardDatabaseHostname oxGuardDatabaseRead oxGuardShardDatabase oxGuardShardRead passwordFromAddress passwordFromName pgpCacheDays publicKeyWhitelist publicPGPDirectory restApiHostname restApiPassword restApiUsername rsaCache rsaCacheCount rsaCertainty rsaKeyLength shardSize supportApiPassword supportApiUsername useStartTLS productName )

    #if all needed files exist
    if [ -e $old_core_file ] && [ -e $new_core_file ]; then
      #make a backup of user changes
      cp $old_core_file $old_core_file_back
      last_index=$(( ${#core_names_22[@]}-1 ))
      for index in $(seq 0 $last_index); do
        old_name=${key_prefix}${core_names_22[$index]}
        new_name=${key_prefix}${core_names_24[$index]}
        #if property is uncommented
        if $(ox_exists_property ${old_name} ${old_core_file}); then
          value=$(ox_read_property ${old_name} ${old_core_file})
          #and property has a value
          if [ -n "${value}" ]; then
            ox_comment ${new_name} remove ${new_core_file}
            ox_set_property ${new_name} "${value}" ${new_core_file}
          fi
        fi
      done
    fi

    # SoftwareChange_Request-2907
    if [ -e "/opt/open-xchange/guard/oxguardpass" ]; then
        mv /opt/open-xchange/guard/oxguardpass /opt/open-xchange/etc/oxguardpass
    fi

    # SoftwareChange_Request-2928
    if [ -e "/opt/open-xchange/guard/private_dns_key" ]; then
        rm /opt/open-xchange/guard/private_dns_key
    fi
    if [ -e "/opt/open-xchange/guard/public_dns_key" ]; then
        rm /opt/open-xchange/guard/public_dns_key
    fi
    find /opt/open-xchange -name guard -type d -empty -delete

    # SoftwareChange_Request-3307
    ox_add_property com.openexchange.guard.defaultAdvanced false /opt/open-xchange/etc/guard-core.properties

    # SoftwareChange_Request-3313
    ox_add_property com.openexchange.guard.trustedPGPDirectory "" /opt/open-xchange/etc/guard-core.properties
    ox_add_property com.openexchange.guard.untrustedPGPDirectory "" /opt/open-xchange/etc/guard-core.properties

    # SoftwareChange_Request-3318
    ox_add_property com.openexchange.guard.mailResolverUrl.basicAuthUsername "" /opt/open-xchange/etc/guard-core.properties
    ox_add_property com.openexchange.guard.mailResolverUrl.basicAuthPassword "" /opt/open-xchange/etc/guard-core.properties

    # SoftwareChange_Request-3357
    ox_add_property com.openexchange.guard.authLifeTime 1W /opt/open-xchange/etc/guard-core.properties
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
/opt/open-xchange/templates/guard
/opt/open-xchange/i18n/*
/opt/open-xchange/bundles/com.openexchange.guard.*
/opt/open-xchange/lib/com.openexchange.guard.*
/opt/open-xchange/osgi/bundle.d/com.openexchange.guard.*
/opt/open-xchange/sbin/guard
%config(noreplace) %attr(640, root, open-xchange) /opt/open-xchange/etc/guard-core.properties
%config(noreplace) /opt/open-xchange/etc/meta/guard.yml
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/guard/uploads

%changelog
* Wed Sep 14 2016 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2016-09-21 (3561)
* Wed Aug 17 2016 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2016-08-17 (3493)
* Tue Jul 12 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.4.2 release
* Wed Jul 06 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.2 release
* Wed Jun 29 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second preview for 2.4.2 release
* Thu Jun 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.2 release
* Thu Jun 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.4.2
* Thu Apr 28 2016 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2016-05-04 (3262)
* Wed Apr 20 2016 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2016-04-22 (3245)
* Wed Mar 30 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.4.0 release
* Thu Mar 24 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.0 release
* Wed Mar 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
Fifth preview of 2.4.0 release
* Fri Mar 04 2016 Marcus Klein <marcus.klein@open-xchange.com>
Fourth preview of 2.4.0 release
* Sat Feb 20 2016 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 2.4.0 release
* Fri Feb 05 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.4.0 release
* Fri Feb 05 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.4.0 release
* Sun Dec 06 2015 Greg <greg@ubuntu>
Second candidate for 2.2.1 release
* Mon Nov 09 2015 Greg <greg@ubuntu>
First candidate for 2.2.1 release
* Mon Nov 09 2015 Greg <greg@ubuntu>
First release 2.2.1
* Fri Oct 23 2015 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.4.0 release
* Mon Oct 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate release for 2.2.0
* Sun Sep 27 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate release for 2.2.0
* Mon Sep 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate release 2.2.0
* Mon Sep 14 2015 Greg Hill <greg.hill@open-xchange.com>
Build for patch 2015-09-24 (2756)
* Mon Sep 14 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate release 2.2.0
* Mon Aug 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 2.2.0 release
* Mon Aug 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 2.2.0 release
* Mon Aug 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 2.2.0 release
* Wed Jul 29 2015 Greg Hill <greg.hill@open-xchange.com>
Build for patch 2015-07-27 (2626)
* Wed Jul 08 2015 Greg Hill <greg.hill@open-xchange.com>
Build for patch 2015-07-09 (2612)
* Tue Jun 30 2015 Greg Hill <greg.hill@open-xchange.com>
Final release candidate for Guard 2.0
* Mon Jun 29 2015 Greg Hill <greg.hill@open-xchange.com>
Fifth candidate for 2.0
* Sun Jun 28 2015 Greg Hill <greg.hill@open-xchange.com>
Fourth candidate for 2.0 release
* Sun Jun 21 2015 Greg Hill <greg.hill@open-xchange.com>
Third candidate for 2.0 release
* Sun Jun 14 2015 Greg Hill <greg.hill@open-xchange.com>
Second candidate for 2.0 release
* Sun Jun 07 2015 Greg Hill <greg.hill@open-xchange.com>
First candidate for 2.0 release
* Mon Feb 09 2015 Greg Hill <greg.hill@open-xchange.com>
prepare for 2.0.0 release
* Sun Jan 04 2015 Greg Hill <greg.hill@open-xchange.com>
Third candidate for 1.2.0 release
* Wed Dec 10 2014 Greg Hill <greg.hill@open-xchange.com>
Second candidate for 1.2.0 release
* Thu Oct 30 2014 Greg Hill <greg.hill@open-xchange.com>
Build for 1.2
* Fri Oct 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-09
* Wed Sep 03 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 1.0.0 release
* Tue Sep 02 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 1.0.0 release
* Thu Aug 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 1.0.0 release
* Thu Aug 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 1.0.0
