/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.pgp;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.guard.servlets.AbstractGuardServlet;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.OXGuardSessionAuthenticationHandler;

/**
 * Provides general PGP functionality
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class PGPServlet extends AbstractGuardServlet{

    private static final long serialVersionUID = -5662408424447605671L;
    private static final String GET_EXTERNAL_PUBLIC_KEYLIST_ACTION = "getpublist";
    private static final String GET_USER_KEYS_ACTION = "getuserkeys";
    private static final String GET_VERIFY_SIGNATURES_ACTION = "getsignatures";
    private static final String GET_PUBLIC_KEY_DETAILS_ACTION = "getpubdetail";
    private static final String GET_KEY_IMAGE_ACTION = "getkeyimage";
    private static final String GET_PRIVATE_KEY_ACTION = "getprivkeybyid";
    private static final String GET_SET_CURRENT_KEY_ACTION = "makecurrent";
    private static final String DELETE_EXTERNAL_PUBLIC_KEY_ACTION = "share";
    private static final String PUT_EXTERNAL_KEY_SHARE_MODE_ACTION = "share";
    private static final String PUT_EXTERNAL_KEY_INLINE_MODE_ACTION = "inline";
    private static final String PUT_SAVE_DECODED_ATTACHMENT_ACTION = "savedecodedattachment";
    private static final String POST_UPLOAD_EXTERNAL_PUBLIC_KEYS_ACTION = "uploadkeys";
    private static final String POST_UPLOAD_KEYS_ACTION = "uploadprivate";
    private static final String POST_DELETE_KEY_RING_ACTION = "deleteprivkey";
    private static final String POST_DELETE_PUBLIC_KEY_ACTION = "deletelocalpublic";
    private static final String POST_REVOKE_PRIVATE_KEY_ACTION = "revokeprivkey";
    private static final String POST_ADD_UID_ACTION = "adduserid";

    private final HashMap<String, GuardServletAction> getActions;
    private final HashMap<String, GuardServletAction> deleteActions;
    private final HashMap<String, GuardServletAction> putActions;
    private final HashMap<String, GuardServletAction> postActions;

    public PGPServlet(){

        OXGuardSessionAuthenticationHandler sessionAuthenticationHandler = new OXGuardSessionAuthenticationHandler();

        //GET
        getActions = new HashMap<String,GuardServletAction>();
        getActions.put(GET_EXTERNAL_PUBLIC_KEYLIST_ACTION, new GetExternalPublicKeyListAction().setAuthenticationHandler(sessionAuthenticationHandler));
        getActions.put(GET_USER_KEYS_ACTION, new GetUserKeysAction().setAuthenticationHandler(sessionAuthenticationHandler));
        getActions.put(GET_VERIFY_SIGNATURES_ACTION, new VerifyKeySignaturesAction().setAuthenticationHandler(sessionAuthenticationHandler));
        getActions.put(GET_PUBLIC_KEY_DETAILS_ACTION, new GetPublicKeyDetailsAction().setAuthenticationHandler(sessionAuthenticationHandler));
        getActions.put(GET_KEY_IMAGE_ACTION, new GetKeyImageAction().setAuthenticationHandler(sessionAuthenticationHandler));
        getActions.put(GET_PRIVATE_KEY_ACTION, new GetPrivateKeyAction().setAuthenticationHandler(sessionAuthenticationHandler));
        getActions.put(GET_SET_CURRENT_KEY_ACTION, new SetCurrentKeyAction().setAuthenticationHandler(sessionAuthenticationHandler));

        //DELETE
        deleteActions = new HashMap<String,GuardServletAction>();
        deleteActions.put(DELETE_EXTERNAL_PUBLIC_KEY_ACTION, new DeleteExternalPublicKeyAction().setAuthenticationHandler(sessionAuthenticationHandler));

        //PUT
        putActions = new HashMap<String,GuardServletAction>();
        putActions.put(PUT_EXTERNAL_KEY_SHARE_MODE_ACTION, new SetExternalKeyShareModeAction().setAuthenticationHandler(sessionAuthenticationHandler));
        putActions.put(PUT_EXTERNAL_KEY_INLINE_MODE_ACTION, new SetExternalKeyInlineModeAction().setAuthenticationHandler(sessionAuthenticationHandler));
        putActions.put(PUT_SAVE_DECODED_ATTACHMENT_ACTION, new SaveDecodedAttachmentAction().setAuthenticationHandler(sessionAuthenticationHandler));

        //POST
        postActions = new HashMap<String,GuardServletAction>();
        postActions.put(POST_UPLOAD_EXTERNAL_PUBLIC_KEYS_ACTION, new UploadPublicKeysAction().setAuthenticationHandler(sessionAuthenticationHandler));
        postActions.put(POST_UPLOAD_KEYS_ACTION, new UploadKeysAction().setAuthenticationHandler(sessionAuthenticationHandler));
        postActions.put(POST_DELETE_KEY_RING_ACTION, new DeleteKeyRingAction().setAuthenticationHandler(sessionAuthenticationHandler));
        postActions.put(POST_DELETE_PUBLIC_KEY_ACTION, new DeletePublicKeyAction().setAuthenticationHandler(sessionAuthenticationHandler));
        postActions.put(POST_REVOKE_PRIVATE_KEY_ACTION, new RevokePrivateKeyAction().setAuthenticationHandler(sessionAuthenticationHandler));
        postActions.put(POST_ADD_UID_ACTION, new KeyAddUserIdAction().setAuthenticationHandler(sessionAuthenticationHandler));
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        super.doAction(request, response, getActions);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        super.doAction(request, response, deleteActions);
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        super.doAction(request, response, putActions);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        super.doAction(request, response, postActions);
    }
}

