
package com.openexchange.guard.servlets.authentication;

import java.util.Locale;

/**
 * {@link GuardUserSession} Represents a user session for Guard
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class GuardUserSession {

    private final String sessionId;
    private final int userId;
    private final int contextId;
    private final Locale locale;

    /**
     * Initializes a new {@link GuardUserSession}.
     * 
     * @param sessionId the Appsuite session id or a guard guest session ID
     * @param contextId the context id
     * @param userId the user id
     * @param locale The user's locale
     */
    public GuardUserSession(String sessionId, int contextId, int userId, Locale locale) {
        this.sessionId = sessionId;
        this.userId = userId;
        this.contextId = contextId;
        this.locale = locale;
    }

    /**
     * @return the Appsuite session id
     */
    public String getSessionId() {
        return sessionId;
    }

    /**
     * @return the user id
     */
    public int getUserId() {
        return userId;
    }

    /**
     * @return the context id
     */
    public int getContextId() {
        return contextId;
    }

    /**
     * @return the user's locale
     */
    public Locale getLocale() {
        return locale;
    }

}
