package com.openexchange.guard.pgp;

import java.util.Iterator;

import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;

import com.openexchange.exception.OXException;
import com.openexchange.guard.keys.GuardKeyService;
import com.openexchange.guard.keys.dao.GuardKeys;
import com.openexchange.guard.osgi.Services;

/**
 * Class for verifying userID is contained in a key
 * @author greg
 *
 */
public class PGPUserIdChecker {

	/**
	 * Parse through all userids in all public keys to see if any contain the email address
	 * @param userid
	 * @param cid
	 * @param email
	 * @return
	 * @throws OXException
	 */
	public static boolean checkHasUID (int userid, int cid, String email) throws OXException {
		GuardKeyService keyService = Services.getService(GuardKeyService.class);
        GuardKeys senderKeys = keyService.getKeys(userid, cid);
        PGPPublicKeyRing ring = senderKeys.getPublicKeyRing();
        Iterator<PGPPublicKey> keys = ring.getPublicKeys();
        while (keys.hasNext()) {
        	PGPPublicKey key = keys.next();
        	Iterator<String> ids = key.getUserIDs();
        	while (ids.hasNext()) {
        		String id = ids.next();
        		if (id != null) {
        			if (id.toLowerCase().contains(email)) return (true);
        		}
        	}
        }
        return false;
	}
}
