/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgp;

import java.util.List;
import com.google.gson.JsonObject;
import com.openexchange.guard.keys.dao.RecipKey;
import com.openexchange.guard.mail.Attachment;
import com.openexchange.guard.oxapi.OxCookie;

/**
 * {@link PGPMail}
 *
 * @author <a href="mailto:martin.schneider@open-xchange.com">Martin Schneider</a>
 * @since v2.4.0
 */
public class PGPMail {

    private final boolean draft;
    private final String draftFolder;
    private final JsonObject content;
    private final List<Attachment> attachments;
    private final String password;
    private final List<RecipKey> recipients;
    private final String guestmessage;
    private final String pin;
    private final int templateId;
    private final OxCookie oxCookie;
    private final int userid;
    private final int cid;
    private final String session;
    private final boolean inline;
    private final boolean pgpsign;
    private final String useragent;

    public PGPMail(boolean draft, String draftFolder, JsonObject content, List<Attachment> attachments, String password, List<RecipKey> recipients, String guestmessage, String pin, int templateId, OxCookie oxCookie, int userid, int cid, String session, boolean inline, boolean pgpsign, String useragent) {
        this.draft = draft;
        this.draftFolder = draftFolder;
        this.content = content;
        this.attachments = attachments;
        this.password = password;
        this.recipients = recipients;
        this.guestmessage = guestmessage;
        this.pin = pin;
        this.templateId = templateId;
        this.oxCookie = oxCookie;
        this.userid = userid;
        this.cid = cid;
        this.session = session;
        this.inline = inline;
        this.pgpsign = pgpsign;
        this.useragent = useragent;
    }

    public boolean isDraft() {
        return draft;
    }

    public String getDraftFolder() {
        return draftFolder;
    }
 
    public JsonObject getContent() {
        return content;
    }

    public List<Attachment> getAttachments() {
        return attachments;
    }

    public String getPassword() {
        return password;
    }

    public List<RecipKey> getRecipients() {
        return recipients;
    }

    public String getGuestmessage() {
        return guestmessage;
    }

    public String getPin() {
        return pin;
    }

    public int getTemplateId() {
        return templateId;
    }

    public OxCookie getOXCookie() {
        return oxCookie;
    }

    public int getUserid() {
        return userid;
    }

    public int getCid() {
        return cid;
    }

    public String getSession() {
        return session;
    }

    public boolean isInline() {
        return inline;
    }

    public boolean isPgpsign() {
        return pgpsign;
    }

    public String getUseragent() {
        return useragent;
    }
}
