/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.mailvelope.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.database.GuardDatabaseService;
import com.openexchange.guard.database.utils.DBUtils;
import com.openexchange.guard.mailvelope.MailvelopeStorage;
import com.openexchange.guard.osgi.Services;

public class MailvelopeStorageImpl implements MailvelopeStorage {

    private static Logger logger = LoggerFactory.getLogger(MailvelopeStorageImpl.class);

    @Override
    public boolean saveBackupData(String data, int userid, int cid) throws OXException {
        GuardDatabaseService guardDatabaseService = Services.getService(GuardDatabaseService.class);
        Connection connection = null;
        connection = guardDatabaseService.getWritable(cid);

        PreparedStatement stmt = null;
        try {
            String command = MailvelopeStorageSql.updateBackup;
            stmt = connection.prepareStatement(command);
            stmt.setInt(1, userid);
            stmt.setInt(2, cid);
            stmt.setString(3, data);
            stmt.setString(4, data);
            stmt.execute();
        } catch (Exception e) {
            logger.error("Problem updating mailvelope data ", e);
            return (false);
        } finally {
            DBUtils.closeSQLStuff(stmt);
            guardDatabaseService.backWritable(cid, connection);
        }

        return true;
    }

    @Override
    public String getBackupData(int userid, int cid) throws OXException {
        GuardDatabaseService guardDatabaseService = Services.getService(GuardDatabaseService.class);
        Connection connection = null;
        connection = guardDatabaseService.getReadOnly(cid);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        String data = null;
        try {
            String command = MailvelopeStorageSql.getBackupData;
            stmt = connection.prepareStatement(command);
            stmt.setInt(1, userid);
            stmt.setInt(2, cid);
            resultSet = stmt.executeQuery();

            if (resultSet.next()) {
                data = resultSet.getString("keydata");
            }
        } catch (Exception e) {
            logger.error("Problem reading mailvelope data ", e);
        } finally {
            DBUtils.closeSQLStuff(resultSet, stmt);
            guardDatabaseService.backReadOnly(cid, connection);
        }
        return (data);
    }

}
