/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.mailvelope;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;

public class BackupHandler {

    public BackupData decodeBackup(String armored, String passphrase) throws IOException {

        InputStream in = new ByteArrayInputStream(armored.getBytes("UTF-8"));
        in = PGPUtil.getDecoderStream(in);
        PGPObjectFactory pgpF = new PGPObjectFactory(in, new BcKeyFingerprintCalculator());
        PGPEncryptedDataList enc;
        PGPSecretKeyRing ringData = null;
        String password = null;
        //reading first part of the stream
        Object o = pgpF.nextObject();
        while (o != null) {
            //the first object might be a PGP marker packet.
            if (o instanceof PGPEncryptedDataList) {
                enc = (PGPEncryptedDataList) o;
            } else {
                enc = (PGPEncryptedDataList) pgpF.nextObject();
            }
            Iterator<?> it = enc.getEncryptedDataObjects();
            while (it.hasNext()) {
                Object encrObj = it.next();
                if (encrObj instanceof PGPPBEEncryptedData) {
                    PGPPBEEncryptedData sym = (PGPPBEEncryptedData) encrObj;
                    try {
                        final InputStream clear = sym.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(passphrase.toCharArray()));
                        PGPObjectFactory clearFactory = new PGPObjectFactory(clear, new BcKeyFingerprintCalculator());
                        Object dobject = clearFactory.nextObject();
                        while (dobject != null) {
                            if (dobject instanceof PGPCompressedData) {
                                PGPCompressedData compData = (PGPCompressedData) o;
                                clearFactory = new PGPObjectFactory(compData.getDataStream(), new BcKeyFingerprintCalculator());
                                dobject = clearFactory.nextObject();
                            }
                            if (dobject instanceof PGPLiteralData) {
                                PGPLiteralData literal = (PGPLiteralData) dobject;
                                InputStream lis = literal.getInputStream();
                                final byte[] buffer = new byte[4096];
                                int len;
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                while ((len = lis.read(buffer)) >= 0) {
                                    out.write(buffer, 0, len);
                                }
                                String decoded = new String(out.toByteArray());
                                String[] lines = decoded.split("\r");
                                for (String line : lines) {
                                    line = line.replace("\n", "");
                                    if (line.startsWith("Pwd:")) {
                                        password = line.replace("Pwd:", "").trim();
                                    }
                                }
                            }
                            if (dobject instanceof PGPSecretKeyRing) {
                                ringData = (PGPSecretKeyRing) dobject;
                            }

                            dobject = clearFactory.nextObject();
                        }

                    } catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }
            o = pgpF.nextObject();
        }
        if (password != null && ringData != null) {
            return (new BackupData(password, ringData));
        }
        return (null);
    }
}
