/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.ratifier.internal;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.java.Strings;
import com.openexchange.guard.oxapi.Normalizer;
import com.openexchange.guard.ratifier.GuardRatifierService;
import com.openexchange.guard.ratifier.exceptions.GuardRatifierExceptionCodes;

/**
 * {@link GuardRatifierServiceImpl}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class GuardRatifierServiceImpl implements GuardRatifierService {

    private static final Logger logger = LoggerFactory.getLogger(GuardRatifierServiceImpl.class);

    /**
     * Initialises a new {@link GuardRatifierServiceImpl}.
     */
    public GuardRatifierServiceImpl() {
        super();
    }

    @Override
    public void validate(String email) throws OXException {
        if (Strings.isEmpty(email)) {
            throw GuardRatifierExceptionCodes.INVALID_EMAIL_ADDRESS.create(email);
        }
        if (!email.contains("@")) {
            throw GuardRatifierExceptionCodes.INVALID_EMAIL_ADDRESS.create(email);
        }
        try {
            String aceConformMailAddress = IDNA.toACE(new String(email));
            InternetAddress e = new InternetAddress(aceConformMailAddress);
            e.validate();
        } catch (AddressException e) {
            logger.warn("{}", e);
            throw GuardRatifierExceptionCodes.INVALID_EMAIL_ADDRESS.create(e, email);
        }
    }

    @Override
    public String normalise(String data) throws OXException {
        return new Normalizer().normalizeString(data);
    }
}
