
package com.openexchange.guard.pgpcore.services.impl.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.guard.cipher.GuardCipherAlgorithm;
import com.openexchange.guard.cipher.GuardCipherFactoryService;
import com.openexchange.guard.cipher.GuardCipherService;
import com.openexchange.guard.email.storage.ogEmail.EmailStorage;
import com.openexchange.guard.keys.GuardKeyService;
import com.openexchange.guard.keys.storage.KeyTableStorage;
import com.openexchange.guard.keys.storage.PGPKeysStorage;
import com.openexchange.guard.pgpcore.services.PGPCryptoService;
import com.openexchange.guard.pgpcore.services.PGPSigningService;
import com.openexchange.guard.pgpcore.services.TokenAuthenticationService;
import com.openexchange.guard.pgpcore.services.impl.DBKeyRetrievalStrategy;
import com.openexchange.guard.pgpcore.services.impl.PGPCryptoServiceImpl;
import com.openexchange.guard.pgpcore.services.impl.PGPSigningServiceImpl;
import com.openexchange.guard.pgpcore.services.impl.TokenAuthenticationServiceImpl;
import com.openexchange.guard.session.GuardSessionService;
import com.openexchange.osgi.HousekeepingActivator;

public class PGPCoreServicesImplActivator extends HousekeepingActivator {

    /**
     * Internal method to get an appropriated cipher service
     * 
     * @return a cipher service
     * @throws OXException
     */
    private GuardCipherService GetCipherService() throws OXException {
        GuardCipherFactoryService cipherFactory = getService(GuardCipherFactoryService.class);
        return cipherFactory.getCipherService(GuardCipherAlgorithm.AES_GCM);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.openexchange.osgi.DeferredActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { GuardCipherFactoryService.class, GuardKeyService.class, PGPKeysStorage.class, EmailStorage.class,
            KeyTableStorage.class, GuardSessionService.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void startBundle() throws Exception {
        org.slf4j.LoggerFactory.getLogger(PGPCoreServicesImplActivator.class).info("Starting bundle: {}", context.getBundle().getSymbolicName());

        //Register the services
        registerService(TokenAuthenticationService.class, new TokenAuthenticationServiceImpl(getService(GuardKeyService.class),
            getService(GuardSessionService.class), GetCipherService()));
        registerService(PGPCryptoService.class, new PGPCryptoServiceImpl(getService(GuardKeyService.class),
            new DBKeyRetrievalStrategy(getService(PGPKeysStorage.class), getService(EmailStorage.class), getService(KeyTableStorage.class))));
        registerService(PGPSigningService.class, new PGPSigningServiceImpl(getService(GuardKeyService.class),
            new DBKeyRetrievalStrategy(getService(PGPKeysStorage.class), getService(EmailStorage.class), getService(KeyTableStorage.class))));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void stopBundle() throws Exception {
        org.slf4j.LoggerFactory.getLogger(PGPCoreServicesImplActivator.class).info("Stopping bundle: {}", this.context.getBundle().getSymbolicName());
        unregisterService(TokenAuthenticationService.class);
        unregisterService(PGPCryptoService.class);
        unregisterService(PGPSigningService.class);
        super.stopBundle();
    }
}
