/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keys.storage;

import java.util.ArrayList;
import java.util.Date;
import com.openexchange.exception.OXException;
import com.openexchange.guard.keys.dao.DeletedKey;

/**
 * {@link DeletedKeysStorage} provides access to backed up deleted keys
 */
public interface DeletedKeysStorage {

    /**
     * Inserts keys into the storage
     * 
     * @param deletedKeys The keys to insert
     * @throws OXException
     */
    public void insert(DeletedKey... deletedKeys) throws OXException;

    /**
     * Exposes every deleted key for a user for downloading by setting the exposed
     * 
     * @param email The email of the keys to expose
     * @param cid Context id
     * @throws OXException
     */
    public void setExposedForEmail(String email, int cid) throws OXException;

    /**
     * Gets the first deleted key for a user
     * 
     * @param email the email of the user to the get the deleted key's salt
     * @param cid the context id
     * @return the salt of the first found deleted key of the given user
     * @throws OXException
     */
    public DeletedKey getFirstForEmail(String email, int cid) throws OXException;

    /**
     * Removes the exposed flag from all deleted keys which have been exposed before the given date
     * 
     * @param before the date to
     * @return the number of keys which have been reset to "unexposed"
     * @throws OXException
     */
    public int setAllUnexposed(Date before) throws OXException;

    /**
     * Gets a list of all deleted keys for the user, most recent first
     * 
     * @param email
     * @param id
     * @param cid
     * @return
     * @throws OXException
     */
    public ArrayList<DeletedKey> getAllExposedForEmail(String email, int id, int cid) throws OXException;
}
