/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keys.dao;

/**
 * {@link PGPKeys} represents a mapping from a userId and contextId to a PGP Key id
 */
public class PGPKeys {

    private final long id;
    private final String email;
    private final String hexId;
    private final int contextId;
    private final boolean local;
    private final long keyId;

    /**
     * Initializes a new {@link PGPKeys}.
     * 
     * @param id the public key's id
     * @param email the mail
     * @param hexId the public Key's id in hex
     * @param contextId the context id
     * @param local whether the key is marked as local or not
     * @param keyId the key id
     */
    public PGPKeys(long id, String email, String hexId, int contextId, boolean local, long keyId) {
        this.id = id;
        this.email = email;
        this.hexId = hexId;
        this.contextId = contextId;
        this.local = local;
        this.keyId = keyId;
    }

    public long getId() {
        return id;
    }

    public String getEmail() {
        return email;
    }

    public String getHexId() {
        return hexId;
    }

    public int getContextId() {
        return contextId;
    }

    public boolean isLocal() {
        return local;
    }

    public long getKeyId() {
        return keyId;
    }
}
