package com.openexchange.guard.keys.dao;

import java.util.List;

/**
 * {@link KeyParserResult} represents a ASCII-armored key parsing result
 */
public class KeyParserResult {

    private final List<String> publicKeys;
    private final List<String> privateKeys;

    /**
     * Initializes a new {@link KeyParserResult}.
     * @param publicKeys a set of parsed ASCII-armored public keys
     * @param privateKeys a set of parsed ASCII-armored private keys
     */
    public KeyParserResult(List<String> publicKeys, List<String> privateKeys) {
        this.publicKeys = publicKeys;
        this.privateKeys = privateKeys;
    }

    /**
     * @return a set of parsed ASCII-armored public keys
     */
    public List<String> getPublicKeys() {
        return publicKeys;
    }

    /**
     * @return a set of parsed ASCII-armored private keys
     */
    public List<String> getPrivateKeys() {
        return privateKeys;
    }
}