
package com.openexchange.guard.keys;

import java.util.Collection;
import com.openexchange.exception.OXException;
import com.openexchange.guard.keys.internal.hkpclient.RemoteKeyResult;

/**
 * {@link HKPClientService}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public interface HKPClientService {

    /**
     * Tries to find all public PGP keys for the given email
     * 
     * @param clientToken an identification token put into the X-UI-INTERNAL-ACCOUNT-ID header, or null not not set the header
     * @param email The email to get the public keys for
     * @return A list of public keys found for the given email
     * @throws OXException
     */
    public Collection<RemoteKeyResult> find(String clientToken, String email) throws OXException;

    /**
     * Tries to find a specific key by ID
     * 
     * @param clientToken an identification token put into the X-UI-INTERNAL-ACCOUNT-ID header, or null not not set the header
     * @param id The ID of the key
     * @param email (optional) Email address of the sender. If null, no SRV lookup
     * @return The public key for the given id
     * @throws OXException
     */
    public RemoteKeyResult find(String clientToken, Long id, String email) throws OXException;

}
