/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class AAAARecordTest
extends TestCase {
    Name m_an;
    Name m_rn;
    InetAddress m_addr;
    String m_addr_string;
    byte[] m_addr_bytes;
    long m_ttl;

    protected void setUp() throws TextParseException, UnknownHostException {
        this.m_an = Name.fromString("My.Absolute.Name.");
        this.m_rn = Name.fromString("My.Relative.Name");
        this.m_addr_string = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
        this.m_addr = InetAddress.getByName(this.m_addr_string);
        this.m_addr_bytes = this.m_addr.getAddress();
        this.m_ttl = 79225L;
    }

    public void test_ctor_0arg() throws UnknownHostException {
        AAAARecord ar = new AAAARecord();
        AAAARecordTest.assertNull((Object)ar.getName());
        AAAARecordTest.assertEquals((int)0, (int)ar.getType());
        AAAARecordTest.assertEquals((int)0, (int)ar.getDClass());
        AAAARecordTest.assertEquals((long)0L, (long)ar.getTTL());
        AAAARecordTest.assertNull((Object)ar.getAddress());
    }

    public void test_getObject() {
        AAAARecord ar = new AAAARecord();
        Record r = ar.getObject();
        AAAARecordTest.assertTrue((boolean)(r instanceof AAAARecord));
    }

    public void test_ctor_4arg() {
        AAAARecord ar = new AAAARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        AAAARecordTest.assertEquals((Object)this.m_an, (Object)ar.getName());
        AAAARecordTest.assertEquals((int)28, (int)ar.getType());
        AAAARecordTest.assertEquals((int)1, (int)ar.getDClass());
        AAAARecordTest.assertEquals((long)this.m_ttl, (long)ar.getTTL());
        AAAARecordTest.assertEquals((Object)this.m_addr, (Object)ar.getAddress());
        try {
            new AAAARecord(this.m_rn, 1, this.m_ttl, this.m_addr);
            AAAARecordTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new AAAARecord(this.m_an, 1, this.m_ttl, InetAddress.getByName("192.168.0.1"));
            AAAARecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (UnknownHostException e) {
            AAAARecordTest.fail((String)e.getMessage());
        }
    }

    public void test_rrFromWire() throws IOException {
        DNSInput di = new DNSInput(this.m_addr_bytes);
        AAAARecord ar = new AAAARecord();
        ar.rrFromWire(di);
        AAAARecordTest.assertEquals((Object)this.m_addr, (Object)ar.getAddress());
    }

    public void test_rdataFromString() throws IOException {
        Tokenizer t = new Tokenizer(this.m_addr_string);
        AAAARecord ar = new AAAARecord();
        ar.rdataFromString(t, null);
        AAAARecordTest.assertEquals((Object)this.m_addr, (Object)ar.getAddress());
        t = new Tokenizer("193.160.232.1");
        ar = new AAAARecord();
        try {
            ar.rdataFromString(t, null);
            AAAARecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_rrToString() {
        AAAARecord ar = new AAAARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        AAAARecordTest.assertEquals((String)this.m_addr_string, (String)ar.rrToString());
    }

    public void test_rrToWire() {
        AAAARecord ar = new AAAARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        DNSOutput dout = new DNSOutput();
        ar.rrToWire(dout, null, true);
        AAAARecordTest.assertTrue((boolean)Arrays.equals(this.m_addr_bytes, dout.toByteArray()));
        dout = new DNSOutput();
        ar.rrToWire(dout, null, false);
        AAAARecordTest.assertTrue((boolean)Arrays.equals(this.m_addr_bytes, dout.toByteArray()));
    }
}

