/**
 * grunt-check-dependencies
 * https://github.com/mzgol/grunt-check-dependencies
 *
 * Author Michał Gołębiowski <m.goleb@gmail.com>
 * Licensed under the MIT license.
 */

'use strict';

var cloneDeep = require('lodash.clonedeep');
var checkDependencies = require('check-dependencies');

module.exports = function (grunt) {
    grunt.registerMultiTask('checkDependencies', 
    'Checks if currently installed npm dependencies are installed in the exact ' + 
    'same versions that are specified in package.json', 
    function () {
        var options = cloneDeep(this.options());
        var done = this.async();
        var needContinue = options.continue === true;

        options.log = grunt.verbose.writeln;
        options.error = grunt.log.error;

        // Our verbose mode represents check-dependencies verbose mode but even in non-verbose
        // mode we want to have error messages logged so from check-dependencies perspective
        // we're always verbose.
        options.verbose = true;

        checkDependencies(options, function (output) {
            // The checkDependencies function succeeds if dependencies were mismatched
            // but `npm install` ended fine; however, in case of mismatch we might have
            // obsolete Grunt tasks loaded so it's better to fail this time and require
            // a re-run.
            if (output.status === 0 && !output.depsWereOk) {
                if (!needContinue) {
                    grunt.log.error(
                    'Dependencies have been updated. Please re-run your Grunt task.');}}


            done(output.status === 0 && (output.depsWereOk || needContinue));});});};
//# sourceMappingURL=data:application/json;base64,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
