/*
 *

 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.pgpcore;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.exception.OXException;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.configuration.GuardProperty;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.servlets.AbstractGuardServlet;
import com.openexchange.guard.servlets.GuardErrorResponseRenderer;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.BasicAuthServletAuthenticationHandler;
import com.openexchange.guard.servlets.authentication.GuardAuthenticationHandler;

/**
 * {@link PGPCoreServlet}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.2
 */
public class PGPCoreServlet extends AbstractGuardServlet {

    private static final long serialVersionUID = -7751294336216449509L;
    private static final String POST_ENCRYPT_ACTION = "encrypt";
    private static final String POST_DECRYPT_ACTION = "decrypt";
    private static final String POST_SIGN_ACTION = "sign";
    private static final String POST_VERIFY_ACTION = "verify";
    private static final String POST_CREATE_AUTH_ACTION = "createauthtoken";
    private static final String POST_DELETE_AUTH_ACTION = "deleteauthtoken";
    private final HashMap<String, GuardServletAction> postActions;
    private final HashMap<String, GuardServletAction> putActions;
    
    /**
     * Internal method to create an authentication handler which protects the API
     * 
     * @return An authentication handler to use
     * @throws OXException
     */
    private GuardAuthenticationHandler createAuthenticationHandler() throws OXException {
        GuardConfigurationService configService = Services.getService(GuardConfigurationService.class);
        return new BasicAuthServletAuthenticationHandler(configService.getProperty(GuardProperty.restApiUsername),
            configService.getProperty(GuardProperty.restApiPassword));
    }

    /**
     * Initializes a new {@link PGPCoreServlet}.
     * 
     * @throws OXException
     */
    public PGPCoreServlet() throws OXException {
         //Using 500 as default error code for OXExceptions for the core PGP API
        super(new GuardErrorResponseRenderer(HttpServletResponse.SC_INTERNAL_SERVER_ERROR));
        
        GuardAuthenticationHandler authHandler = createAuthenticationHandler();
        
        //POST
        postActions = new HashMap<String, GuardServletAction>();
        postActions.put(POST_CREATE_AUTH_ACTION, new CreateAuthenticationTokenAction().setAuthenticationHandler(authHandler));
        postActions.put(POST_DELETE_AUTH_ACTION, new DeleteAuthenticationTokenAction().setAuthenticationHandler(authHandler));
        postActions.put(POST_ENCRYPT_ACTION, new EncryptAction().setAuthenticationHandler(authHandler));
        postActions.put(POST_DECRYPT_ACTION, new DecryptAction().setAuthenticationHandler(authHandler));
        postActions.put(POST_SIGN_ACTION, new SignAction().setAuthenticationHandler(authHandler));
        postActions.put(POST_VERIFY_ACTION, new VerifyAction().setAuthenticationHandler(authHandler));
        
        //PUT
        putActions = new HashMap<String, GuardServletAction>();
        //Also making the delete action available via PUT for backward compatibility reason
        putActions.put(POST_DELETE_AUTH_ACTION, new DeleteAuthenticationTokenAction().setAuthenticationHandler(authHandler));
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        super.doAction(request, response, postActions);
    }
    
    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPut(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
       super.doAction(request, response, putActions);
    }
}
