/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgp.signing;

import com.openexchange.exception.OXException;
import com.openexchange.guard.oxapi.OxCookie;

/**
 * Provide functionality for signing E-Mails and verify E-Mail signatures
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public interface GuardEmailSigningService {

    /**
     * Verifies the signature of a MIME message
     * @param cookie The UI cookie used for accessing the OX backend
     * @param session The UI session
     * @param userAgent The client's user agent
     * @param emailFolder the folder containing the email
     * @param emailId the ID of the email
     * @param userId the ID of the user
     * @param contextId the context ID
     * @return the verification result
     * @throws Exception
     */
    EmailSignatureVerificationResult verifyMimeEmailSignature(OxCookie cookie, String session, String userAgent, String emailFolder, String emailId, int userId, int contextId) throws OXException;

    /**
     * Verifies the signature of an inline message
     * @param cookie The UI cookie used for accessing the OX backend
     * @param session The UI session
     * @param userAgent The client's user agent
     * @param emailFolder the folder containing the email
     * @param emailId the ID of the email
     * @param attachmentId The ID of the attachment representing the Mail body
     * @param userId the ID of the user
     * @param contextId the context ID
     * @return the verification result
     * @throws Exception
     */
    EmailSignatureVerificationResult verifyInlineEmailSignature(OxCookie cookie, String session, String userAgent, String emailFolder, String emailId, int attachmentId, int userId, int contextId) throws OXException;
}
