// Karma configuration
// Generated on Mon Jul 14 2014 13:52:18 GMT+0200 (CEST)
var fs = require('fs');
var _ = require('lodash');
var localConf = {};

if (fs.existsSync('grunt/local.conf.json')) {
    localConf = JSON.parse(fs.readFileSync('grunt/local.conf.json'));
}
module.exports = function(config) {
  config.set(_.extend({}, {

    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: 'build/',

    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['ox-ui', 'sinon', 'mocha', 'chai'],


    // list of files / patterns to load in the browser
    files: [
      'spec/test-main.js',
      {pattern: 'apps/**/*.js', included: false},
      {pattern: 'spec/**/*_spec.js', included: false},
      {pattern: 'spec/fixtures/**/*.*', included: false},
      {pattern: 'spec/shared/*.js'}
    ],


    // list of files to exclude
    exclude: [
    ],


    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
    },


    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['spec'],


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: false,


    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['PhantomJS'],


    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: false,

    appserver: localConf.appserver,
    coreDir: localConf.coreDir
  }, localConf.karma || {}));
};
