/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 *  2016-2020 OX Software GmbH, Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Julian Baeume <julian.baeume@open-xchange.com>
 */
define('oxguard/util', [
'mailvelope/main',
'settings!oxguard'
], function (mapi, settings) {
    'use strict';

    var api = {};

    /**
     * Test if guard is configured.
     *
     * @return true if configured; false otherwise
     */
    api.isGuardConfigured = function () {
        if (window.oxguarddata === undefined) return false;
        return window.oxguarddata.passcode !== 'No Key';
    };

    api.hasSetupDone = function () {
        var def = $.Deferred();
        if (settings.get('cryptoProvider') === 'guard') {
            if (window.oxguarddata.passcode === 'No Key') {
                def.reject();
            } else def.resolve();
            return (def);
        }
        if (settings.get('cryptoProvider') === 'mailvelope') {
            require(['io.ox/core/api/account']).then(function (accountAPI) {
                return accountAPI.getPrimaryAddress();
            }).then(function (email) {
                return $.when(email, mapi.getKeyring());
            }).then(function (email, ring) {
                var fromPromise = $.Deferred();
                ring.exportOwnPublicKey(email[1]).then(function () {
                    fromPromise.resolve();
                }, function (err) {
                    console.log(err);
                    fromPromise.reject('no key');
                });
                return fromPromise;
            }).then(def.resolve, def.reject);
        } else {
            def.reject();
        }
        return (def);
    };

    api.isGuardEnabled = function () {
        return (settings.get('cryptoProvider') === 'guard');
    };

    api.getCryptoProvider = function () {
        return (settings.get('cryptoProvider'));
    };

    return api;
});
