define('oxguard/settings/defaults', [
    'mailvelope/main',
    'io.ox/core/capabilities'
], function (api, capabilities) {
    'use strict';

    function getDefault () {
        if (!api.isMailvelopeSupported()) {
            return 'guard';
        } else if (!capabilities.has('guard')) {
            // We only force Mailvelope if Guard not yet set up
            return 'mailvelope';
        }
        return undefined;
    }

    return {
        cryptoProvider: getDefault()
    };
});
