/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/settings', [
    'io.ox/core/extensions',
    'gettext!oxguard'
], function (ext, gt) {
    'use strict';

    // Add settings for encryption to the Settings Page
    ext.point('io.ox/settings/pane/main').extend({
        id: 'oxguard',
        //#. %s product Name
        title: gt.format(gt.pgettext('app', '%s Security'), window.oxguarddata.productName),
        index: 600,
        loadSettingPane: true
    });

});
