define('oxguard/pgp/uploadkeys', [
    'io.ox/core/notifications',
    'gettext!oxguard'
], function (notify, gt) {
    'use strict';

    var uploading = false;

    function upload(files, priv, pgp, guard, emailList) {
        var deferred = $.Deferred();
        if (uploading) return;
        uploading = true;
        var formData = new FormData();
        for (var l = 0; l < files.length; l++) {
            if (files[l] !== undefined)
                formData.append('file' + l, files[l]);
        }
        if (priv) {
            formData.append('pgp', pgp);
            formData.append('password', guard);
        }
        var url = ox.apiRoot + '/oxguard/pgp?action=' + (priv ? 'uploadprivate' : 'uploadkeys') +
        '&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id + '&language=' + ox.language;
        if (emailList !== undefined) {
            url = url + '&emailaddress=' + encodeURIComponent(emailList);
        }
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            processData: false, // tell jQuery not to process the data
            contentType: false, // tell jQuery not to set contentType
            success: function (data) {
                if (data === null) data = '';
                if (data.length > 10) {  // If JSON data
                    try {
                        var keys = JSON.parse(data);
                        var added = gt('Added keys: \r\n');
                        for (var i = 0; i < keys.length; i++) {
                            for (var j = 0; j < keys[i].length; j++) {
                                for (var k = 0; k < keys[i][j].ids.length; k++) {  // Will be displaying as text, so convert from html markup
                                    keys[i][j].ids[k] = $('<div/>').html(keys[i][j].ids[k]).text();
                                }
                                added = added + gt('Key ID: ') + keys[i][j].Key + ' ' + keys[i][j].ids + '\r\n';
                            }
                            added = added + '\r\n';
                        }
                        notify.yell('success', added);
                    } catch (e) {
                        console.log(e);
                    }
                } else {
                    notify.yell('success', gt('Keys uploaded'));
                }
                $('input[name="publicKey"]').val('');
                uploading = false;
                deferred.resolve('OK');
            },
            error: function (XMLHttpRequest) {
                $('input[name="publicKey"]').val('');
                uploading = false;
                var resp = XMLHttpRequest.responseText.trim();
                switch (resp.trim()) {
                    case 'Bad UID':
                        notify.yell('error', gt('Failed to upload') + '\r\n' + gt('Invalid Email Address'));
                        break;
                    case 'Bad ID':
                        notify.yell('error', gt('The public key must have your primary email as a user ID'));
                        break;
                    default:
                        notify.yell('error', gt('Failed to upload') + ' ' + XMLHttpRequest.responseText.trim());
                        break;
                }
                deferred.reject(XMLHttpRequest.responseText.trim());
            }
        });
        return (deferred);
    }

    function uploadPrivate (files, err) {
        var deferred = $.Deferred();
        require (['io.ox/core/tk/dialogs'], function (dialogs) {
            var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter: 'ok' });
            dialog.header($('<h4>').text(gt('Upload Private Keys')));
            var explain = $('<div><p>' + gt('Please enter passwords for the upload') + '</p>');

            var passdiv = $('<div>').addClass('row-fluid');
            var newogpassword = $('<input name="guardpassword" type="password"/>');
            var newogpassword2 = $('<input name="guardpassword2" type="password"/>');
            var hint = $('<td>');
            var pw1 = $('<tr>').append($('<td class="pw">').append('<em>' + gt('Enter new password for the key:') + '</em>')).append($('<td>').append(newogpassword));
            var pw2 = $('<tr>').append($('<td class="pw">').append('<em>' + gt('Confirm Password:') + '</em>')).append($('<td>').append(newogpassword2));
            var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
            var table = $('<table class="og_password_prompt"/>')
            .append(noSaveWorkAround)
            .append('<tr><td class="pw"><em>' + gt('Private key password for the key you are uploading:') + '</em></td><td><input name="pgppassword" type="password"/></td></tr>')
            .append(pw1)
            .append(pw2)
            .append($('<tr>').append('<td>').append(hint));
            var errormessage = $('<span id="uploaderror" style="color:red;"></span>');
            passdiv.append(table);
            require (['oxguard/core/passwords'], function (pass) {
                pass.passwordCheck(newogpassword, hint);
                pass.passwordCompare(newogpassword2, newogpassword, hint);
            });
            dialog.getBody().append(explain).append(passdiv).append(errormessage);
            dialog
            .addPrimaryButton('ok', gt('OK'), 'ok')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('cancel', function () {
            })
            .on('ok', function () {
                var pgp = $('input[name="pgppassword"]').val();
                var guard = $('input[name="guardpassword"]').val();
                var guard2 = $('input[name="guardpassword2"]').val();
                if (guard !== guard2) {
                    uploadPrivate (files, gt('Passwords not equal'));
                    return;
                }
                if (window.oxguarddata.settings.min_password_length !== undefined) {  // Check min password length
                    if (guard.trim().length < window.oxguarddata.settings.min_password_length) {
                        uploadPrivate (files, gt('New password must be at least %s characters long', window.oxguarddata.settings.min_password_length));
                        return;
                    }
                } else {
                    if (guard.trim().length < 2) { // If no min defined, make sure at least 2 characters there
                        uploadPrivate (files);
                        return;
                    }
                }
                upload (files, true, pgp, guard)
                .done(function () {
                    notify.yell('success', gt('Private Key Uploaded'));
                    deferred.resolve('OK');
                })
                .fail(function (e) {
                    console.log(e);
                    deferred.reject(e.trim());
                    handleFail (e, notify);
                });
            })
            .show(function () {
                if (err !== undefined) {
                    errormessage.text(err);
                }
                if (!_.device('ios')) {
                    $('input[name="pgppassword"]').focus();
                }
            });
        });
        return (deferred);
    }

    function handleFail (e, notify) {
        if (e === 'duplicate') {
            notify.yell('error', gt('This key already exists'));
            return;
        }
        if (e === 'Bad pgp') {
            notify.yell('error', gt('Bad PGP Password'));
            return;
        }
        if (e === 'Bad password') {
            notify.yell('error', gt('Bad Password'));
            return;
        }
        if (e === 'Bad ID') {
            notify.yell('error', gt('The private key must have your primary email as a user ID'));
            return;
        }
        if (e === 'Bad Merge Password') {
            notify.yell('error', gt('Must use same password as existing key to merge'));
            return;
        }
        notify.yell('error', gt('Problem uploading Private Key ') + e);
    }

    return {
        upload: upload,
        uploadPrivate: uploadPrivate
    };

});
