define('oxguard/pgp/saveattach',[
    'io.ox/mail/api',
    'io.ox/core/http',
    'io.ox/core/notifications',
    'settings!io.ox/core',
    'io.ox/core/folder/api',
    'io.ox/core/folder/picker',
    'settings!io.ox/files', // yep, files not mail!
    'settings!io.ox/core',
    'gettext!oxguard'
], function (api, http, notifications, coreConfig, folderAPI, picker, settings, settingsCore, gt) {

    'use strict';

    function commit(list, target, decode) {
        // For Mime attachments, the mime body needs to be decoded, then the attachment reEncrypted if desired
        function saveDecodedAttachments(list, target, reEncrypt) {
            // be robust
            target = target || coreConfig.get('folder/infostore');
            // support for multiple attachments
            list = _.isArray(list) ? list : [list];
            var def = $.Deferred();
            var files_exist = false;
            // loop
            _(list).each(function (data) {
                if (data.pgpFormat !== undefined) {
                    if (data.parent) {
                        files_exist = true;
                        var params = {
                                action: 'attachment',
                                id: data.parent.id,
                                encrextrapass: data.extrapass,
                                filename: data.filename,
                                folder: data.parent.folder_id,
                                dest_folder: target,
                                inline: data.pgpFormat === 'pgpinline',
                                attachment: data.id,
                                folder_id: target,
                                session_id: ox.session,
                                userid: ox.user_id,
                                cid: ox.context_id,
                                epassword: data.epass,
                                auth: window.oxguarddata.passcode,
                                reEncrypt: reEncrypt,
                                description: 'Saved mail attachment'
                            };
                        $.ajax({
                            type: 'PUT',
                            url: ox.apiRoot + '/oxguard/pgp?action=savedecodedattachment&session=' + ox.session,
                            data: JSON.stringify(params),
                            contentType:'application/json; charset=utf-8',
                            success: function (data) {
                                try {
                                    data = _.isArray(data) ? data[0] : data;
                                    if (data.error !== undefined) {
                                        def.reject(data.error);
                                    }
                                } catch (e) {
                                    console.log(e);
                                }
                                def.resolve('success');
                            }
                        })
                        .fail(function (data) {
                            def.reject(data.responseText);
                        });
                    }
                }
            });
            if (!files_exist) {
                def.reject(gt('no files'));
            }
            return (def);
        }

        notifications.yell('busy',
            gt.ngettext('Saving attachment to Drive', 'Saving attachments to Drive', list.length) + ' ...'
        );

        saveDecodedAttachments(list, target, !decode).done(function () {
            notifications.yell('success',
                gt.ngettext('Attachment has been saved', 'Attachments have been saved', list.length)
            );
            folderAPI.reload(target, list);
        }).fail(function (data) {
            if (data == 'Failed to decrypt') {  // Translate known error messages
                data = gt('Failed to decrypt');
            }
            if (data == 'Failed to save') { // Generic error, no additional lines needed
                data = '';
            }
            notifications.yell('error', gt('Failed to save attachments') + '\r\n' + data);
        });
    }

    return {

        multiple: function (list, decode) {
            var id = settings.get('folderpopup/last') || settingsCore.get('folder/infostore');

            picker({

                button: gt('Save'),
                folder: id,
                module: 'infostore',
                persistent: 'folderpopup',
                root: '9',
                settings: settings,
                title: gt('Save attachment'),
                hideTrashfolder: true,

                done: function (target) {
                    commit(list, target, decode);
                },

                disable: function (data) {
                    return !folderAPI.can('create', data);
                }
            });
        }
    };
});
