/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/passwords', [
], function () {
    'use strict';

    // Create password prompt that defeats the autocomplete
    function createPasswordInput (id, name, options) {
        if (name === undefined) name = id;
        var passString = '<input ' +
        (name === undefined ? '' : 'name = "' + name + '" ') +
        (id === undefined ? '' : 'id = "' + id + '" ') +
                'type="password" autocomplete="off" readonly onfocus="this.removeAttribute(\'readonly\');"/>' +
        (options === undefined ? '' : options);
        return $(passString);
    }

    return {
        createPasswordInput: createPasswordInput
    };

});

