define('oxguard/mail/register_compose', [
    'io.ox/core/extensions',
    'gettext!oxguard',
    'io.ox/backbone/mini-views/dropdown',
    'oxguard/mail/oxguard_mail_compose_core',
    'oxguard/util',
    'pgp_mail/toggle-encryption',
    'io.ox/backbone/mini-views/help',
    'settings!oxguard',
    'oxguard/mail/mail_metrics',
    'less!pgp_mail/style',
    'less!oxguard/style'
], function (ext, gt, Dropdown, core, util, ToggleEncryption, HelpView, settings, metrics) {
    'use strict';

    var sendingSigned = false;

    ext.point('io.ox/mail/compose/fields').extend({
        id: 'toggle-encryption',
        index: 'last',
        draw: function (baton) {
            var go = function (baton) {
                var node = baton.view.$el.find('.row.sender');
                var view = new ToggleEncryption.View({
                    model: baton.model
                });
                view.noLinkMail(baton.view);

                //HACK: always insert first, since we do not control
                //other content
                node.prepend(view.render().$el);

                // Handle secureReply.  Set to encrypted
                if (window.oxguarddata) {
                    if (window.oxguarddata.action === 'secureReply') {
                        if (window.oxguarddata.settings.oxguard === false || window.oxguarddata.settings.secureReply) {
                            view.forceEncryption();
                        } else {
                            baton.model.set('encrypt', true);
                        }
                    }
                }

                //register crypto provider choice wizard
                require(['oxguard/tour/main', 'io.ox/core/capabilities'], function (registry, capabilities) {
                    //skip if no choice is possible
                    if (settings.get('cryptoProvider') !== undefined || !capabilities.has('mailvelope && guard')) return;

                    baton.model.listenTo(baton.model, 'change:encrypt', function (model, val) {
                        if (val !== true || settings.get('cryptoProvider') !== undefined || !capabilities.has('mailvelope && guard')) return;

                        //no setup, yet. do not encrypt
                        model.set('encrypt', false);
                        require(['oxguard/tour/main'], function (registry) {
                            registry.get('default/oxguard/choice').get('run')().then(function () {
                                //TODO: remove this "change:encrypt" handler
                                //setup complete, encrypt!
                                model.set('encrypt', true);
                            }, function () {
                                if (ox.debug) console.log(arguments);
                            });
                        });
                    });
                });
            };
            waitForEditor (baton, go);
        }
    });

    ext.point('io.ox/mail/compose/fields').extend({
        id: 'drawGuard',
        draw: function (baton) {
            if (!util.isGuardEnabled()) return;
            if (window.oxguarddata) {  // If mailvelope only, will not have any data
                var go = function (baton) {
                    require (['oxguard/mail/options_new'], function (options) {
                        options.createOptions(baton);
                    });
                };
                waitForEditor (baton, go);
            }
        }
    });

    function waitForEditor (baton, go) {
        if (baton.view.editor === null) {
            window.setTimeout(function () {
                try {
                    if (baton.view.editor === null) {
                        waitForEditor(baton, go);
                    } else go (baton);
                } catch (e) {
                    console.log(e);
                }

            }, 200);
            return;
        } else go (baton);
    }

    ext.point('io.ox/mail/compose/createtoken').extend({
        id: 'guardToken',
        action: function (baton) {
            if (util.isGuardEnabled()) {
                if (baton.model.get('encrypt') === true) {
                    var email = baton.event.attrs.model.get('token').value;
                    var target = $(baton.event.relatedTarget);
                    require(['oxguard/mail/keymanager'], function (keyman) {
                        var result = keyman.checkRecips (email, baton);
                        if (result !== null) {
                            core.drawKeyIcons(result, target);
                        }
                    });
                }
            }
        }
    });

    ext.point('io.ox/mail/compose/composetoolbar').extend({
        id: 'security',
        index: 150,
        draw: function (baton) {
            var node = this;
            if (util.isGuardEnabled()) {
                drawDropDown (baton, $(node));
            } else {
                settings.on('change:cryptoProvider', function () {
                    if (util.isGuardEnabled()) {
                        drawDropDown (baton, $(node));
                        require (['oxguard/mail/options_new'], function (options) {
                            options.createOptions(baton);
                        });
                    }
                });
            }
        }
    });

    function drawDropDown (baton, node) {
        if (window.oxguarddata && window.oxguarddata.settings) {
            if (window.oxguarddata.settings.oxguard) {
                setQuit (baton);  // Set handles for quit function
                var dropdown = new Dropdown({ model: baton.model, label: gt('Security'), caret: true });
                if (settings.get('advanced')) {
                    dropdown
                        .header(gt('PGP'));
                } else {
                    dropdown
                    .header(gt('Security'));
                }
                dropdown
                    .option('encrypt', true, (settings.get('advanced') ? gt('Encrypt') : gt('Secure')))
                    .option('PGPSignature', true, gt('Sign'));
                if (settings.get('advanced')) {
                    dropdown
                  //#. Format of the email, HTML or Plaintext
                    .header(gt('Format'))
                    .option('PGPFormat', 'mime', gt('PGP Mime'))
                    .option('PGPFormat', 'inline', gt('PGP Inline'));
                    dropdown
                    .header(gt('Keys'))
                    .option('PubKey', true, gt('Attach My Key'));
                }
                var div = node.find('.col-xs-4');
                var dropdownDiv = dropdown.render().$el.addClass('text-left').css('padding-left', '20px');
                if (!_.device('small')) {
                    dropdownDiv.find('ul').prepend(new HelpView({
                        base: 'help-guard',
                        iconClass: 'guardhelp',
                        href: 'ox.guard.user.sect.email.send.html',
                        tabindex: '-1'
                    }).render().$el.css('float', 'right').css('margin-right', '10px'));
                }
                div.append(dropdownDiv);
                node.find('div[data-extension-id="add_attachments"]').append(div);
            }
        }
    }

    // Check to see if Guard email if quiting.  If so, needs to save draft securely
    function setQuit (baton) {
        var app = baton.view.app;
        app.setQuit(function () {
            if (baton.model.get('encrypt') && app.view) {
                return guardQuit(baton, app);
            } else {
                if (app.view) return app.view.discard();
            }
        });
    }

    // Replace discard dialog so that drafts saved securely
    function guardQuit(baton, app) {
        var self = baton.view,
        def = $.Deferred();
        if (app.model.dirty()) {
            require(['io.ox/core/tk/dialogs'], function (dialogs) {
                //button texts may become quite large in some languages (e. g. french, see Bug 35581)
                //add some extra space
                //TODO maybe we could use a more dynamical approach
                new dialogs.ModalDialog({ width: 550, container: _.device('smartphone') ? self.$el.closest('.window-container-center') : $('#io-ox-core') })
                    .text(gt('Do you really want to discard your message?'))
                    //#. "Discard message" appears in combination with "Cancel" (this action)
                    //#. Translation should be distinguishable for the user
                    .addPrimaryButton('delete', gt.pgettext('dialog', 'Discard message'), 'delete', { tabIndex: 1 })
                    .addAlternativeButton('savedraft', gt('Save as draft'), 'savedraft', { tabIndex: 1 })
                    .addButton('cancel', gt('Cancel'), 'cancel', { tabIndex: 1 })
                    .show()
                    .done(function (action) {
                        if (action === 'delete') {
                            // clean before resolve, otherwise tinymce gets half-destroyed (ugly timing)
                            self.clean();
                            def.resolve();
                        } else if (action === 'savedraft') {
                            require (['oxguard/mail/sender_compose'], function (sender) {
                                sender.draftMail(baton, window.oxguarddata.passcode)
                                .done(function () {
                                    self.clean();
                                    def.resolve();
                                }).fail(def.reject);
                            });
                        } else {
                            def.reject();
                        }
                    });
            });
        } else {
            self.clean();
            def.resolve();
        }

        return def;
    }

    var sendpoint = ext.point('io.ox/mail/compose/buttons');
    sendpoint.replace({
        id: 'send',
        draw: function (baton) {
            this.append($('<button type="button" class="btn btn-primary" data-action="send">')
                .on('click', function () {
                    if (baton.model.get('encrypt') && util.isGuardEnabled()) {
                        if (isReady(baton)) {
                            doSend(baton);
                        } else {
                            waitUntilReady(baton);
                        }
                    } else {
                        if (baton.model.get('PGPSignature')) { // If for PGP Signature
                            if (!util.isGuardConfigured()) {  // Check if user already set up
                                require (['oxguard/oxguard_core'], function (core) {
                                    core.metrics('mail', 'create-keys-for-signature');
                                    core.createKeysWizard()
                                    .done(function () {
                                        sendSigned(baton);
                                    });
                                });
                                return;// Do not send until the master key is created
                            } else {
                                sendSigned(baton);
                            }

                        } else {
                            if (baton.model.get('headers') !== undefined) {
                                baton.model.get('headers')['X-OX-Guard-Marker'] = false;
                            }
                            baton.view.send();
                        }
                    }
                })
                .on('keyup', function (e) {
                    if ((e.keyCode || e.which) === 27) baton.view.focusEditor();
                })
                .text(gt('Send')));
        }
    });

    function isReady (baton) {
        function checkKey (key) {
            return (!key.pending);
        }
        var keys = baton.model.get('gkeys');
        return (keys.every(checkKey));
    }

    // If not all keys returned, wait until completed.
    // Timeout if no backend response
    function waitUntilReady (baton) {
        baton.waiting = true;
        var win = baton.view.app.getWindow();
        win.busy();
        baton.model.on('change:gkeys', function () {
            if (isReady(baton)) {
                win.idle();
                doSend(baton);
                baton.waiting = false;
            }
        });
        window.setTimeout(function () {
            if (baton !== undefined) {
                if (baton.waiting === true) {
                    win.idle();
                    baton.waiting = false;
                    doSend(baton);
                }
            }
        }, 7000);
    }

    function doSend (baton) {
        require (['oxguard/mail/sender_compose'], function (sender) {
            var subject = baton.model.get('subject');
            if (subject === undefined || subject.trim() === '') {
                require(['io.ox/core/tk/dialogs'], function (dialogs) {
                    new dialogs.ModalDialog({ focus: false })
                        .text(gt('Mail has empty subject. Send it anyway?'))
                        .addPrimaryButton('send', gt('Yes, send without subject'), 'send', { tabIndex: 1 })
                        .addButton('subject', gt('Add subject'), 'subject', { tabIndex: 1 })
                        .show(function () {
                        })
                        .done(function (action) {
                            if (action === 'send') {
                                sender.sendMail(baton, window.oxguarddata.passcode);
                            } else {
                                baton.view.$el.find('input[name="subject"]').focus();
                                return;
                            }
                        });
                });
            } else sender.sendMail(baton, window.oxguarddata.passcode);
        });
    }

    function addHeader (baton) {
        var headers = baton.model.get('headers');
        if (headers === undefined) headers = {};
        var newheaders = {
            'X-OX-Guard-Marker': true
        };
        var headers = _.extend(headers, newheaders);
        baton.model.set('headers', headers);
    }

    // Event if sending email fails and signing, remove auth
    ox.on('mail:send:fail', function () {
        if (sendingSigned === true) {
            require(['oxguard/oxguard_core'], function (ocore) {
                ocore.removeAuth();
            });
        }
    });

    // Send plaintext signed email
    function sendSigned (baton) {
        metrics.track('send-plaintext-signed');
        require(['oxguard/oxguard_core', 'io.ox/core/notifications'], function (ocore, notify) {
            ocore.checkAuth()
            .done(function () {
                addHeader (baton);
                sendingSigned = true;
                baton.view.send()
                .always(function () {
                    sendingSigned = false;
                });
            })
            .fail(function () {
                ocore.getPassword(gt('Please enter your %s password to sign this email.', window.oxguarddata.productName), true)  //Get password
                .done(function (passdata) {
                    ocore.savePassword(passdata.password, passdata.duration)
                    .done(function () {
                        addHeader (baton);
                        baton.view.send();
                    })
                    .fail(function (data) {
                        if (data.auth === 'Bad Password') {
                            notify.yell('error', gt('Bad Password'));
                        } else {
                            notify.yell('error', gt('Unable to authorize against backend'));
                        }
                    });
                });
            });
        });
    }

    ext.point('io.ox/mail/compose/buttons').replace({
        id: 'save',
        index: 200,
        draw: function (baton) {
            this.append($('<button type="button" class="btn btn-default" data-action="save">')
                .on('click', function () {
                    if (baton.view.isSaving === true) return false;
                    baton.view.isSaving = true;
                    if (baton.view.model.get('encrypt') && util.isGuardEnabled()) {
                        if (!util.isGuardConfigured()) {
                            require (['oxguard/oxguard_core'], function (core) {
                                core.createKeysWizard()
                                .done(function () {
                                    saveDraft(baton);
                                });
                            });
                            baton.view.isSaving = false;
                            return;// Do not send until the master key is created
                        }
                        saveDraft (baton);
                        return;
                    }
                    baton.view.saveDraft().done(function () {
                        baton.view.isSaving = false;
                    }).fail(function () {
                        baton.view.isSaving = false;
                    });
                })
                .text(gt('Save')));
        }
    });

    function saveDraft (baton) {
        require (['oxguard/mail/sender_compose'], function (sender) {
            baton.view.isSaving = true;
            sender.draftMail(baton, window.oxguarddata.passcode)
            .then(function () {
                baton.view.isSaving = false;
            });
        });
    }

});
