/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/mail/prep_reply', [
    'gettext!oxguard'
], function (gt) {
    'use strict';

    function getTo (to, user) {
        var newTo = [];
        for (var i = 0; i < to.length; i++) {
            if (user.indexOf(to[i][1]) < 0) { // dont add the user to recip list
                newTo.push(to[i]);
            }
        }
        return (newTo);
    }

    // Prepare the header for forwarding email.  TextOnly will format as text

    function getForwardHeader (tmp, from, sentDate, textonly) {
        var to = '';
        if (tmp.to) {
            for (var i = 0; i < tmp.to.length; i++) {
                to = to + ' ' + tmp.to[i][0] + ' <' + tmp.to[i][1] + '>';
            }
        }
        var cc = '';
        if (tmp.cc) {
            for (var j = 0; j < tmp.cc.length; j++) {
                cc = cc + ' ' + tmp.cc[j][0] + ' <' + tmp.cc[j][1] + '>';
            }
        }
        var cr = (tmp.replytype.indexOf('html') > 0) ? '<br>' : '\r\n';
        if (textonly === true) cr = '\r\n';
        var line = '----------' + gt('Original Message') + '----------' + cr +
            gt ('From: %1$s', from) + cr +
            gt ('To: %1$s', to) + cr +
            (cc === '' ? '' : (gt ('CC: %1$s', cc) + cr)) +
            gt ('Date: %1$s', sentDate.toLocaleString()) + cr +
            gt ('Subject: %1$s', tmp.subject) + cr;
        return (line);
    }

    // Format an email for reply
    function prepareReply(tmp, action) {
        var header = '';
        try {
            if (tmp === null) return ('');
            if (tmp.replytext === undefined) return ('');
            var sentDate = new Date(tmp.received_date);
            var from = tmp.from === undefined ? (tmp.replyfrom[0][0] + ' <' + tmp.replyfrom[0][1] + '>') : (tmp.from[0][0] +  ' <' + tmp.from[0][1] + '>');
            var line = '';
            if (action === 'forward') {
                line = getForwardHeader (tmp, from, sentDate);
            } else {
                //#. Used for top of reply email, %1 is date, %2 is name
                //#. Would appear like - On 4/5/14 12:30 Greg sent:
                line = gt('On %1$s %2$s sent:', sentDate.toLocaleString(), from);
            }
            if (tmp.replytype === undefined) tmp.replytype = '';
            if (tmp.replytype.indexOf('html') > 0) {
                header = '<br/><blockquote type="cite"><span>' + line + '</span><br/>' + tmp.replytext + '</blockquote>';
                //  header = '<br/><div style="border-left: 1px solid blue; padding-left:10px;"><span>' + line + '</span><br/>' + tmp.replytext + '</div>';
            } else {
                header = '\r\n\r\n---------------------------------------\r\n' + line + '\r\n' + tmp.replytext;
            }
            return (header);
        } catch (e) {
            console.log(e);
            return (header);
        }
    }

    // Generate Plaintext email reply
    function prepareTextReply (tmp, action) {
        try {
            if (tmp === null) return ('');
            if (tmp.replytext === undefined) return ('');
            var sentDate = new Date(tmp.received_date);
            var from = tmp.from === undefined ? (tmp.replyfrom[0][0] + ' <' + tmp.replyfrom[0][1] + '>') : (tmp.from[0][0] +  ' <' + tmp.from[0][1] + '>');
            var line = ' ' + gt('On %1$s %2$s sent:', sentDate.toLocaleString(), from);
            if (action === 'forward') {
                line = getForwardHeader (tmp, from, sentDate, true);
            }
            if (tmp.replytype === undefined) tmp.replytype = '';
            var msg = tmp.replytext + '\n';
            return ('\n> ' + line + '\n' + convertHTML(msg));
        } catch (e) {
            console.log(e);
            return ('');
        }
    }

    // Convert HTML email to plaintext
    function convert (html, start) {
        try {
            if (start === undefined)
                start = 0;
            var i = html.indexOf('<blockquote', start);
            if (i > -1) {
                i = html.indexOf('>', i) + 1;
                html = convert(html, i);
            }
            var j = html.indexOf('</blockquote');
            var substring = html.substring(start);
            if (j > -1) {
                substring = html.substring(start, j);
            }
            var newstring = '> ' + substring.replace(/\n/g, '\n> ').replace(/<br[\/]*>/gi, '\n> ')
                .replace(/&gt/gi,'>').replace(/&lt/gi,'<')
                .replace(/<p[\/]*>/gi, '\n> ').replace(/<blockquote[^>]*>/,'\n> ').replace(/<(?:.|\s)*?>/g, '') + '\n> ';
            html = html.replace(substring, newstring);
            return (html);
        } catch (e) {
            console.log(e);
            return (html);
        }
    }

    function convertHTML(html) {
        return (convert(html, 0).replace(/<blockquote[^>]*>/,'\n> ').replace(/<(?:.|\s)*?>/g, ''));
    }

    return {
        prepareReply: prepareReply,
        prepareTextReply: prepareTextReply,
        getTo: getTo
    };

});
